#!/usr/bin/env tclsh

set legalnotice {
tutt_editor_fr.tcl, version 0.1.43RC3
Copyright Jean-Franois Allaeys 2015, 2025

Ce logiciel tutt_editor_fr.tcl est un programme informatique servant,
 partir d'un fichier d'entre lisible par le logiciel d'acoustique TUTT,
 visualiser, modifier et sauver la gomtrie de l'instrument dcrit,
ainsi que la table des doigts. 
Si des rsultats de calculs sont prsents dans le mme rpertoire
que le logiciel, ils peuvent tre visualiss galement.
Si le logiciel TUTT est prsent dans le mme rpertoire que tutt_editor_fr.tcl,
il peut tre lanc depuis tutt_editor_fr.tcl avec comme fichier d'entre 
le fichier ouvert et ventuellement modifi par tutt_editor_fr.tcl.

Ce logciel s'appuie sur tuttessaiW3.tcl, 
du mme auteur que tutt_editor_fr.tcl.

Ce logiciel est rgi par la licence CeCILL version 2.1 soumise au droit franais et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL version 2.1 telle que diffuse par le CEA, le CNRS et l'INRIA 
sur le site "http://www.cecill.info".

En contrepartie de l'accessibilit au code source et des droits de copie,
de modification et de redistribution accords par cette licence, il n'est
offert aux utilisateurs qu'une garantie limite.  Pour les mmes raisons,
seule une responsabilit restreinte pse sur l'auteur du programme,  le
titulaire des droits patrimoniaux et les concdants successifs.

A cet gard  l'attention de l'utilisateur est attire sur les risques
associs au chargement,   l'utilisation,   la modification et/ou au
dveloppement et  la reproduction du logiciel par l'utilisateur tant 
donn sa spcificit de logiciel libre, qui peut le rendre complexe  
manipuler et qui le rserve donc  des dveloppeurs et des professionnels
avertis possdant  des  connaissances  informatiques approfondies.  Les
utilisateurs sont donc invits  charger  et  tester  l'adquation  du
logiciel  leurs besoins dans des conditions permettant d'assurer la
scurit de leurs systmes et ou de leurs donnes et, plus gnralement, 
 l'utiliser et l'exploiter dans les mmes conditions de scurit. 

Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
pris connaissance de la licence CeCILL version 2.1, 
et que vous en avez accept les termes.}

package require Tk
package require tile

toplevel .legalnotice
wm title .legalnotice "tutt_editor_fr.tcl : Notice Lgale"


grid [tk::text .legalnotice.textnotice -width 80 -yscrollcommand {.legalnotice.textbar set}] -column 0 -row 0 -sticky ns
grid [tk::scrollbar .legalnotice.textbar -orient vertical -command {.legalnotice.textnotice yview} ] -column 1 -row 0 -sticky ns
.legalnotice.textnotice insert 0.0 $legalnotice
grid [tk::frame .legalnotice.confirm] -column 0 -columnspan 2 -row 3 -sticky ew
grid [tk::button .legalnotice.confirm.acceptlegal -text "J'accepte" -command "set acceptornot 1"] -column 0 -row 0 -padx 20
grid [tk::button .legalnotice.confirm.declinelegal -text "Je n'accepte pas" -command "exit"] -column 1 -row 0 -padx 20

wm protocol .legalnotice WM_DELETE_WINDOW {
 wm withdraw .legalnotice
 exit
}
wm withdraw .
raise .legalnotice
focus .legalnotice.confirm.acceptlegal
bind .legalnotice.confirm.acceptlegal <Return> "set acceptornot 1"

vwait acceptornot

destroy .legalnotice

wm protocol . WM_DELETE_WINDOW {
  exit_all_program
}


#*******
# Units : 
# if mm : unitL=1000.0
# si on tronque au 1/10 d'unite : precision %1.f
# increment au moins egal a la precision
set unitL 1000.0
set precision {%.1f}
set uincrement 0.1

#**********
# Couleurs
# Par dfaut, lightblue et gold 
# pour rester  facilement discernable par la majorit des daltoniens
set leftcolor steelblue1
set rightcolor gold

set activecolor steelblue

set ximageoffset 50
set Instrument_Screen_Width 800

set Height_Main_Section_Visu 150
set h_gap_graphs 25
set h_graphhole 125
set Height_OrthoVisu 150

set z_impedance_size 410

set graphique0ortho [expr {$Height_Main_Section_Visu+$h_gap_graphs}]
set graphiqueFortho [expr {$graphique0ortho+$Height_OrthoVisu}]

set graphique0trou [expr {$graphiqueFortho+$h_gap_graphs}]
set graphiqueFtrou [expr {$graphique0trou+$h_graphhole}]

set yorthoc [expr {($graphique0ortho+$graphiqueFortho)*0.5}]

set contour3p 0
set contour3m 0
set holesketch3 [list ]

set curname defaultoutput.dat
set curnamenew $curname

set autoopen 0
set macrotorun 0

set macrofiletorun ""

# Analyze command line arguments
# By default, if the first argument is the name of an existing file, 
# assume it is the name of the .dat to open
# If several names of existing files are provided after a -o or -open option, 
# the last one is kept for opening
set lastarg "-open"
foreach iarg $::argv {
  if {[string equal $lastarg "-open"]>0} {
    if {[file exists $iarg]>0} {
      set curname $iarg
      puts "Will try to open $curname"
      incr autoopen
    }
  }
  puts $iarg
  if {[string equal $lastarg "-runmacrofile"]>0} {
    if {[file exists $iarg]>0} {
      set macrofiletorun $iarg
      puts "Will try to run $macrofiletorun"
      incr macrotorun
    }
  }
  set lastarg $iarg
  if {[string equal $lastarg "-o"]>0} {
    set lastarg "-open"
  }
}

set at_least_one_opened 0

set pi [expr {4*atan2(1,1)}]
set doublepi [expr {8*atan2(1,1)}]

# From a list of strings to eval, returns a list of results
proc exprall listtoexpr {
  variable tmpres
  set tmpres [list ]
  foreach ielem $listtoexpr {
    lappend tmpres [expr $ielem]
  }
  return $tmpres
}


proc update_ITMPNT {newITMPNT} {
  global semitone
  global ITMPNT
  if {$newITMPNT*1.0>0} {
    #Octave
    set semitone [expr {12/log(2)}]
    set ITMPNT 1
  } else {
    # Quinte
    set semitone [expr {7/log(1.5)}]
    set ITMPNT 0
  }
}

set file_unsaved 0
set accuracy_change "*"
set pressure_change "*"
set impedance_change "*"

proc calcresult_not_uptodate {} {
  global pressure_change
  set pressure_change "*"
  global accuracy_change
  global last_calc_is_impedance
  set accuracy_change "*"
  if {[winfo exists .visu_accuracy]} {
    wm title .visu_accuracy "Justesse + (Harmonicite) $accuracy_change"
    catch {
      .visu_accuracy.graphical.jgtextwidget configure -background [lindex {"white" "darkgrey"} [string equal $accuracy_change "*"]]
    }
  }
  global impedance_change
  set impedance_change "*"
  if {[winfo exists .visu_impedance]} {
    wm title .visu_impedance "[lindex {Admittance Impdance} $last_calc_is_impedance]  $impedance_change"
  }
  set LVALS [list ]
  set tmpid 0
  global noms_notes
  foreach ival $noms_notes {
    lappend LVALS "[incr tmpid] [regsub -all {'} $ival {}]"
  }
  catch {
    .calclog.sendbar.inputuser configure -values $LVALS
  }
}

proc geofingeringchanged {} {
  global curname
  wm title . "$curname * tutt_editor_fr.tcl"
  global file_unsaved
  set file_unsaved 1
  calcresult_not_uptodate
}

proc geofingeringsaved {} {
  global curname
  wm title . "$curname - tutt_editor_fr.tcl"
  global file_unsaved
  set file_unsaved 0
}

# By default, assume old version
set istutt41 2
set istutt42 0

# Linux (unix) default tutt name
set tuttexename ./Anche5.exe
set exe_prefix "./"

# Windows(windows) tuttname
if {[string equal $tcl_platform(platform) windows]>0} {
  set tuttexename ANCHE4.exe
  set exe_prefix ""
}

set wgeo_clog ""
set wgeo_help ""
set lastuserin {}

set firstlaunch 1
set last_calc_is_impedance 1
set next_calc_is_impedance 1

proc batchcalculate {interactive degree} {
  set act 0
  global ilin
  set ilin 1
  global tuttexename exe_prefix istutt41 istutt42
  global id
  global userin
  global lastuserin
  global wgeo_clog
  global launched
  global firstlaunch
  global IMPADM
  global next_calc_is_impedance last_calc_is_impedance
  puts "$interactive $degree"
  if {[winfo exists .calclog]} {
    set wgeo_clog "[wm geometry .calclog]"
    variable w
    foreach w [winfo children .calclog] {
      destroy $w
    }
  } else {
    toplevel .calclog
    wm protocol .calclog WM_DELETE_WINDOW {
      set wgeo_clog "[wm geometry .calclog]"
      wm withdraw .calclog
      set firstlaunch 1
    }
  }
  wm deiconify .calclog
  wm geometry .calclog [regsub {^[^x]*x[0-9]*([^0-9])} $wgeo_clog {\1}]
  wm geometry .calclog ""
  wm title .calclog {Fentre de calcul TUTT}
  grid [tk::scrollbar .calclog.sztxtbar -orient vertical -command {.calclog.lu yview} ] -column 2 -row 0 -sticky ns
  grid [tk::text .calclog.lu -width 80 -height 20 -yscrollcommand {.calclog.sztxtbar set}] -column 0 -row 0 -sticky ns -columnspan 2

  grid rowconfigure .calclog 0 -weight 1
  #grid [tk::text .lu] -column 0 -row 0 -columnspan 2
  .calclog.lu tag configure BLUFG -foreground blue
  grid [tk::frame .calclog.sendbar] -column 0 -row 1 -columnspan 3 -sticky we
  #grid [tk::entry .calclog.sendbar.inputuser -textvariable userin ] -column 0 -row 1 -sticky e
  global refdoigte_notes
  #set LVALS [lsearch -all -not -start 1 "$refdoigte_notes 0" "NaN" ]
  set LVALS [list ]
  global noms_notes
  set id 0
  foreach ival $noms_notes {
    lappend LVALS "[incr id] [regsub -all {'} $ival {}]"
    }
  grid [radiobutton .calclog.sendbar.impedance -text "Impdance" -variable IMPADM -value -1 -command "
    set datname \"tutt25.dat\"
    set next_calc_is_impedance 1
  if {\$istutt41<1} {
    set datname \"tutt42.dat\"
    if {\$istutt42<1} {
      set datname \"tutt43.dat\"
    }  
  }
  write_datfile_namespace::save_to_filename \$datname
  if {\[catch {set inputtime \[file mtime \$datname\]} errormsg \]} {set mtime 0}
"] -column 0 -row 1 -sticky w
  grid [radiobutton .calclog.sendbar.admittance -text "Admittance" -variable IMPADM -value 1 -command "
    set datname \"tutt25.dat\"
    set next_calc_is_impedance 0
  if {\$istutt41<1} {
    set datname \"tutt42.dat\"
    if {\$istutt42<1} {
      set datname \"tutt43.dat\"
    }  
  }
  write_datfile_namespace::save_to_filename \$datname
  if {\[catch {set inputtime \[file mtime \$datname\]} errormsg \]} {set mtime 0}
"] -column 1 -row 1 -sticky w
  grid [ttk::combobox .calclog.sendbar.inputuser -textvariable userin -values $LVALS] -column 2 -row 1 -sticky e
  grid columnconfigure .calclog.sendbar 2 -weight 1
  grid columnconfigure .calclog.sendbar 3 -weight 1
  set userin $lastuserin
  #update idletasks
  foreach id {<Return> <<ComboboxSelected>>} {
    bind .calclog.sendbar.inputuser $id "
    set lastuserin \$userin
    puts \$id \"\$userin\n\";.calclog.lu insert \$ilin.0 \"\$userin\n\" BLUFG;incr ilin;set act 1;
    .calclog.sendbar.inputuser configure -state disable
    .calclog.sendbar.senduser configure -state disable
    .calclog.sendbar.send0 configure -state disable"
  }
  grid [tk::button .calclog.sendbar.senduser -command "puts \$id \"\$userin\n\";.calclog.lu insert \$ilin.0 \"\$userin\n\" BLUFG;incr ilin;set act 1;    .calclog.sendbar.inputuser configure -state disable
    .calclog.sendbar.senduser configure -state disable
    .calclog.sendbar.send0 configure -state disable"    -text "Send"] -column 3 -row 1 -sticky w
  grid [tk::button .calclog.sendbar.send0 -command "puts \$id 0;.calclog.lu insert \$ilin.0 {0\n} BLUFG;incr ilin;set act 1;    .calclog.sendbar.inputuser configure -state disable
     .calclog.sendbar.send0 configure -state disable
     .calclog.sendbar.senduser configure -state disable" -text "Calculer tous les doigts"] -column 4 -row 1 -sticky e
  .calclog.sendbar.senduser configure -state disable
if {($degree<1) && ($interactive<1)} {
.calclog.lu insert $ilin.0 "Choisissez le numro de doigt  calculer dans le menu droulant en bas de cette fentre,

ou 

cliquer sur le bouton : Calculer tous les doigts"
#focus .calclog.sendbar.send0
focus .calclog.sendbar.inputuser
} else {
set firstlaunch 0
puts "interactive = $interactive"
  #set id [open "|./Anche5.exe > masortie.txt" w]
  #if {"$tuttexename"=="ANCHE4.exe"} {
  # if {$istutt41<1} {
  #    set tuttexename "Tutt42.exe"
  #  }
  #}
  if {$istutt41<1} {
    if {$istutt42>0} {
      set tuttexename "Tutt42.exe"
    } else {
      set tuttexename "Tutt43.exe"
    }
    set tuttexename "$exe_prefix$tuttexename"
    #puts "tuttexename= $tuttexename"
  }
  puts "Tentative de lancement de $tuttexename"
  if {[catch {
  if {$istutt41<1} {
  file delete -force stderr.txt
  #after 1000
  set id [open "|$tuttexename" r+]} else {
  set id [open "|$tuttexename 2>stderr.txt" r+]
  }
  fconfigure $id -buffering none -blocking 0
  focus .calclog.sendbar.inputuser
  puts $id
  
  if {$degree>0} {
  set last_calc_is_impedance $next_calc_is_impedance
  }
  
  if {$interactive>0} {
    puts $id "$degree\n"
    .calclog.lu insert $ilin.0 "$degree\n" BLUFG
    incr ilin
    set act 1
  }
  
  flush $id
  set fini -1
  
  while {$fini<0} {
    set sortir -1
    while {$sortir<0} {
      set alire [gets $id sortie]
      if {$alire<0} {
        if {[expr {![catch {file lstat "stderr.txt" finfo}]}]>0} {
        set id2 [open "stderr.txt" r]
        set fini [gets $id2 line]
        close $id2} else {puts "pas encore de stderr.txt"}
        if {$fini>=0} {
          set sortir 1
        }
      } else {
        set sortir 1
        update idletasks
      }
    }
    if {$alire>=0} {
      #puts $sortie
      after idle ".calclog.lu insert $ilin.0 \"$sortie\\n\""
      incr ilin
    }
    flush $id
  }
  while {[gets $id sortie]>=0} {
    #puts $sortie
    after idle ".calclog.lu insert $ilin.0 \"$sortie\\n\""
    incr ilin
  }
  puts "fin"
  puts $id "\n"
  close $id
  set launched 1
  } errormsg]} { .calclog.lu insert $ilin.0 "$errormsg\n" BLUFG}
  .calclog.sendbar.inputuser configure -state disable
  .calclog.sendbar.senduser configure -state disable
  update idletasks
  }
  foreach id {<Return> <<ComboboxSelected>>} {
    bind .calclog.sendbar.inputuser $id "
    .calclog.sendbar.inputuser configure -state disable
    .calclog.sendbar.senduser configure -state disable
    .calclog.sendbar.send0 configure -state disable
    set lastuserin \$userin
    calculate 1 \$userin"
  }
  .calclog.sendbar.inputuser configure -state normal
  .calclog.sendbar.send0 configure -command "
  .calclog.sendbar.senduser configure -state disable
  .calclog.sendbar.send0 configure -state disable
  calculate 1 0"
  .calclog.sendbar.send0 configure -state normal 

}


proc calculate {interactive degree} {
  global NTESSC
  global launched
  set launched 0
  global firstlaunch
  global istutt41 istutt42
  set datname "tutt25.dat"
  if {$istutt41<1} {
    set datname "tutt42.dat"
    if {$istutt42<1} {
      set datname "tutt43.dat"
    }
  }
  write_datfile_namespace::save_to_filename $datname
  if {[catch {set inputtime [file mtime $datname]} errormsg ]} {set mtime 0}
  # Only if on windows platform and interactive mode
  #if {$interactive<1} {
    #if {[string equal $::tcl_platform(platform) windows]>0} {
    #  #exec cmd /k ANCHE4.exe
    #  # Try to launch Tutt (catch failure if non-Windows system, or if ANCHE4.exe not present)
    #  if { [catch {exec cmd /k ANCHE4.exe} errormsg ]} {
    #    puts "Error : \$errormsg"
    #  }
    #  set launched 1
    #}
  #}
  if {$launched<1} {
    puts "launched < 1 => batch calculate"
    batchcalculate $interactive $degree
  }
  global accuracy_change
  #update idletasks
  if {$firstlaunch<1} {
  mainout_namespace::read_mainout
  if {$degree>0} {
    pressure_visu_namespace::add_visu_pressure
    impedance_visu_namespace::add_visu_impedance
  } else {
  # Refresh Accuracy if results are up to date
  if {[string equal $accuracy_change "N"]>0} {
    accuracy_visu_namespace::add_visu_accuracy
  } elseif {[winfo exist .visu_accuracy]} {
    if {[string equal [wm state .visu_accuracy] withdrawn]>0} {
    # Make the accuracy window appear if not present
      accuracy_visu_namespace::add_visu_accuracy
    }
  } else {
    accuracy_visu_namespace::add_visu_accuracy
  }
  # If Calculus ran into error, set "*" to result titles
  if {$launched<1} {
    puts "calcresult_not_uptodate"
    calcresult_not_uptodate
  }
  }
  } else {
    puts "set firstlaunch 0"
    set firstlaunch 0
  }
}

set old_cursor {}

proc handcursor {myitem} {
  # Save the cursor
  global old_cursor 
  set old_cursor [lindex [$myitem configure -cursor] 4]
  $myitem configure -cursor hand2
}

proc defaultcursor {myitem} {
  # Restore the cursor
  global old_cursor
  $myitem configure -cursor $old_cursor
  set old_cursor {}
}


#set old_edit_finger_status {}

#grid [ttk::frame .tout] -column 0 -row 0 -sticky s

set fontspin {-size -30}

grid [tk::frame  .entete] -sticky nw -column 0 -row 0
set icol 0
grid [tk::button .entete.calculate -text "Calculer" -state disable]    -sticky w -column $icol -row 0
grid [tk::label  .entete.title_label -text "   Nom : "] -sticky w -column [incr icol] -row 0
grid [tk::entry  .entete.title_entry -textvariable titresaisie -width 40] -sticky w -column [incr icol] -row 0
grid [tk::button .entete.edit_fingering -text "Editer Doigts" -command "edit_fingering_namespace::edit_fingering -1" -state disable]    -sticky w -column [incr icol] -row 0
grid [tk::button .entete.savefile -text "Sauver sous" -state disable]    -sticky w -column [incr icol] -row 0
grid [tk::button .entete.exporttoDXF -text "Exporter DXF" -command "exportDXF {}" -state disable]    -sticky w -column [incr icol] -row 0
grid [tk::button .entete.closeopen -text "Ouvrir..." -command "ask_new_file_and_open"]    -sticky w -column [incr icol] -row 0
grid [tk::button .entete.help -text "?" -command "open_help_window {main}"]    -sticky w -column [incr icol] -row 0

.entete.title_entry configure -validate focusout -validatecommand "
if {\[string equal \$titresaisie \$titre\]} {} else {
geofingeringchanged};return 1"

.entete.savefile configure -command "set curnamenew \[tk_getSaveFile -filetypes {{{.DAT file} {.DAT .dat}}} -initialfile \$curname\]
if {\[string length \$curnamenew\]>0} {
set curname \$curnamenew
write_datfile_namespace::save_to_filename \$curname
set curname \[file tail \$curname\]
geofingeringsaved}
"

.entete.calculate configure -command "set lastuserin \"\"
calculate 0 0"

grid [tk::canvas .maincanvas -relief sunken -width [expr {$ximageoffset*2+$Instrument_Screen_Width}] -height [expr {$graphiqueFtrou+$h_gap_graphs}]] -sticky nwes -column 0 -row 1

grid [ttk::separator .separ_etat -orient horizontal] -column 0 -row 5 -sticky nwes
grid [tk::label .status_bar -text ""] -sticky ws -column 0 -row 6


grid columnconfigure . 0 -weight 1
grid rowconfigure . 0 -weight 0

grid rowconfigure . 1 -weight 1
foreach ifor {2 3 4 5 6} {
  grid rowconfigure . $ifor -weight 0
}

# lignes_commentaire : pour recopier 
# dans le fichier de sauvegarde les commentaires du fichier lu
# "0 0" indique que le commentaire qui arrive est a noter si il existe
# [<n> <n+2>] indique que les lignes n  (n+2)-1 sont des commentaires
set lignes_commentaire [list ]

#Espace de travail ddi  la lecture/dcodage d'un fichier d'entre
#Namespace dedicated to reading/decode entry file
namespace eval read_datfile_namespace {
#*******************************************************************
# Definition des fonctions d'aide  la lecture du fichier d'entre :

# Mettre dans la variable mavar le contenu de la ligne numligne
# et renvoyer le contenu de cette ligne
# Si le fichier n'a pas suffisamment de lignes, renvoyer Erreur.Fin.de.Fichier
proc affecte_ligne {mavar numligne} {
  global entrees
  upvar 1 $mavar ligneval
  if {[llength $entrees]>$numligne} {
    set ligneval [lindex $entrees $numligne]
  } else {
    set ligneval "Erreur.Fin.de.Fichier"
    puts {Erreur : Fin de fichier !}
    exit
  }
  return $ligneval
}

# A partir de la ligne numligne, 
# lire et ignorer toutes les lignes successives contenant du texte,
# affecter a mavar la premiere ligne rencontree ne comptant pas de texte
# la variable numligne indique alors le numero de la ligne suivante
# Le contenu de mavar est renvoye egalement
proc affecte_ligne_num {mavar numligne} {
  upvar 1 $mavar ligneval
  upvar 1 $numligne iligne
  global lignes_commentaire
  variable tmpnum $iligne
  while {[string match -nocase {*[A-DF-Z]*} [affecte_ligne ligneval $iligne] ]} {incr iligne}  
  if {[expr {$iligne-$tmpnum}]>0} {lappend lignes_commentaire "$tmpnum $iligne"}
  incr iligne
  return $ligneval
}

# A partir de la ligne numligneliste, recherche la premiere ligne sans texte
# Affecte toutes les valeurs trouvees sur cette ligne a une liste
# Tant que la liste comporte moins d'elements que nelemliste :
# ajoute toutes les valeurs trouvees sur la prochaine ligne sans texte a la liste
# Une fois le nombre d'elements de la liste superieur ou egal a nelemliste :
# Renvoie la liste, que contient egalement la variable mavarliste
# numligneliste vaut l'indice de la derniere ligne lue +1
proc affecte_ligne_liste {mavarliste numligneliste nelemliste} {
  upvar 1 $numligneliste iligne
  upvar 1 $mavarliste tmplst
   set tmplst [list]
   while {[llength $tmplst]<$nelemliste} {
     #regexp : 
     # {\S+} : mot : recherche de tous (-all) les mots, les renvoyer sous forme de liste (-inline)
     # Reunir la liste obtenue jsuq'ici et cette nouvelle liste
     set tmplst [concat $tmplst [regexp -all -inline {\S+} [affecte_ligne_num mavarlocale iligne]]]
   }
   puts "$mavarliste [llength $tmplst] elements affectes : \n $tmplst"
   return $tmplst
}

# Extrait le nom de la note sur la ligne 50 :
#[ regexp -all -inline {\'[^']*\'}  [lindex $entrees 50]]

# Enregistrement en memoire des doigtes :

# A partir de la ligne numligne, 
# lire et ignorer toutes les lignes successives contenant du texte (hors premiere simple quote),
# Une fois une ligne de doigte trouvee, 
#    ajouter le doigte a la liste de doigtes doigtes_notes
#    ajouter le nom de la note  la liste de noms de notes noms_notes
#    ajouter le doublet {degre de tessiture, justesse experimentale} a la liste des degres de tessiture degres_tessiture_notes
# la variable numligne indique alors le numero de la ligne suivante
# Le contenu de la ligne est renvoye egalement
proc affecte_ligne_num_note {doigtes_notes noms_notes degres_tessiture_notes numligne} {
  upvar 1 $doigtes_notes localfingerings_notes
  upvar 1 $noms_notes localnoms_notes
  upvar 1 $degres_tessiture_notes localdegres_tessiture_notes
  upvar 1 $numligne iligne
  
  global lignes_commentaire
  variable tmpnum $iligne
  while {[string match -nocase {*[A-DF-Z]*} [regsub {\'[^']*\'} [affecte_ligne ligneval $iligne] { }]]} {incr iligne}  
  if {[expr {$iligne-$tmpnum}]>0} {lappend lignes_commentaire "$tmpnum $iligne"}
  lappend localfingerings_notes [regexp -all -inline {\S+} [lindex [regexp -inline {^[^']*} $ligneval] 0]]
  set localnoms_notes [concat $localnoms_notes [regexp -inline {\'[^']*\'} $ligneval]]
  lappend localdegres_tessiture_notes [regexp -all -inline {\S+} [regsub {^[^']*\'[^']*\'}  $ligneval {}] ]
  incr iligne
  return $ligneval
}

# Fin de la dfinition des fonctions d'aide  la lecture du fichier d'entre
#***************************************************************************

#******************************************
# Fonction de lecture du fichier d'entre :
proc open_datfile {dat_input_file_name} {
  variable lesglobales {entrees nlignesentree paramphy titre titresaisie istutt41 istutt42 VERSION_TUTT premiereligne
  N C1 D0 DL OFILIB 
  osc_par_k osc_par_M osc_par_K osc_par_Nu RIGID
  L Temperature D0P DLP LP 
  ISTYLE LEVEE FLA ITMPNT 
  NTESSC NTESSG  NTESSB 
  doigtes_notes noms_notes degres_tessiture_notes 
  IFLUTE FCM FCP G0 LA0 ALPHA E0 V0 V1 LEVRES PAREMB DECOUV mreed kreed LBUCC TANDELTA
  DMA DKA DFCM DFCP DLBUCC DDLEMB
  GA GB
  IMPADM
  CJUS CTIM CVOL CEMI CLIB}

  foreach tmpvar $lesglobales {
    global $tmpvar
  }

  foreach tmpvar {computeddegre computednomnote computedstim computedw expectedw} {
    global $tmpvar
    set $tmpvar "Undefined"
  }
  set computedw 0

  global lignes_commentaire
  set lignes_commentaire [list ]
  
#Ouverture du fichier d'entree choisi
  variable fentree [open "$dat_input_file_name" r]
# Sauvegarde nom courant
  global curname
  set curname [file tail $dat_input_file_name]
  ::geofingeringsaved
  
# Mise en memoire de toutes les lignes du fichier dans la liste entrees
  # La ligne n est enregistree comme l'element n de la liste entrees
  # Attention : La premiere ligne du fichier est la ligne 0
  set entrees [list]
  set nlignesentree 0
  while {[gets $fentree ligne] >=0} {
    lappend entrees $ligne
    incr nlignesentree 
    puts $ligne
  }
  close $fentree
  #Enregistrement du nombre de lignes rencontrees dans le fichier
  #set nlignesentree $iligne
  
  puts "[llength $entrees] lignes"
  variable iligne 0
  
# Premiere ligne : titre
  affecte_ligne premiereligne $iligne
  set titre $premiereligne
  puts $titre
  #set titresaisie [expr {$titre}]
  
  incr iligne
  
# Parametres physiques
  lappend lignes_commentaire "0 0"
  affecte_ligne_num paramphy iligne
  puts $paramphy 
  if {$iligne<4} {
  puts "== tutt41"
  puts $titre
  set istutt41 1
  } else {
  puts "== tutt42"
  set istutt41 0
  set curtuttversion [lindex $entrees 1]
  if { "$curtuttversion" == "TUTT42_2024.01" }  {
    puts "== tutt42"
  } else {
    set istutt42 0
  
    puts "== tutt43"
  }
  affecte_ligne titre 2
  puts $titre
  }
  set titresaisie [expr {$titre}]
# N : Nombre de troncons-1
  lappend lignes_commentaire "0 0"
  affecte_ligne_num N iligne
  puts "N = $N"
# Np1 : Nombre de troncons
  set Np1 [expr {$N+1}]
  
# C1 : Tube ouvert (0) ou ferme (1)
  lappend lignes_commentaire "0 0"
  affecte_ligne_num C1 iligne
  set C1 [format "%G" $C1]
  puts $C1
  
#D0 : Diametres des debuts de troncons
  lappend lignes_commentaire "0 0"
  affecte_ligne_liste D0 iligne $Np1
#DL : Diametres des fins de troncons
  lappend lignes_commentaire "0 0"
  affecte_ligne_liste DL iligne $Np1
  
#Rugosite :
#OFILIB : Rapports entre surface libre reelle de la perce et surface libre macroscopique
  lappend lignes_commentaire "0 0"
  affecte_ligne_liste OFILIB iligne $Np1
  
  if {$istutt42>0} {
  
  lappend lignes_commentaire "0 0"
  affecte_ligne_liste PARAM_OSCILL_PAROI iligne 4
  set ifor 0
  foreach iparam [list osc_par_k osc_par_M osc_par_K osc_par_Nu] {
        set $iparam [lindex $PARAM_OSCILL_PAROI $ifor]
        puts "$iparam = [expr $$iparam]"
        incr ifor
  }
  
  #Rigidite des troncons
  lappend lignes_commentaire "0 0"
  affecte_ligne_liste RIGID iligne $Np1
  
}
#L : Longueurs des troncons
  lappend lignes_commentaire "0 0"
  affecte_ligne_liste L iligne $Np1
  
#Temperature en haut du tube et en bas du tube (degres celcius)
  lappend lignes_commentaire "0 0"
  affecte_ligne_liste Temperature iligne 2
  puts "Temperature haut, bas :"
  
#D0P : Diametres des debuts de cheminees laterales (exterieur)
  lappend lignes_commentaire "0 0"
  affecte_ligne_liste D0P iligne $N
#DLP : Diametres des fins de cheminees laterales (interieur)
  lappend lignes_commentaire "0 0"
  affecte_ligne_liste DLP iligne $N
#LP : Hauteurs des cheminees laterales
  lappend lignes_commentaire "0 0"
  affecte_ligne_liste LP iligne $N
  
#ISTYLE : Styles des cles des trous lateraux (0 : pas de cle, 1 : plateau creux, 2 :plateau plein)
  lappend lignes_commentaire "0 0"
  affecte_ligne_liste ISTYLE iligne $N
#LEVEE : Levees des cles (hauteur de la cle levee au dessus de la cheminee)
  lappend lignes_commentaire "0 0"
  affecte_ligne_liste LEVEE iligne $N
  
#FLA : Frequence du 'la' de reference
  lappend lignes_commentaire "0 0"
  affecte_ligne_num FLA iligne
  puts "FLA : $FLA"
#ITMPNT : Donne le temperament de reference (1 : egal a octaves justes, 0 : egal a quintes justes)
  lappend lignes_commentaire "0 0"
  affecte_ligne_num ITMPNT iligne
  puts "ITMPNT : $ITMPNT"
  update_ITMPNT $ITMPNT
  
#Tessiture
  lappend lignes_commentaire "0 0"
  affecte_ligne_liste TESSITURE iligne 3
#NTESSC : Nombre total de notes etudiees
  set NTESSC [lindex $TESSITURE 0]
#NTESSG : Nombre de demi-tons contenus dans la tessiture
  set NTESSG [lindex $TESSITURE 1]
#NTESSB : Nombre de demi-tons au dessous du 'la' de refrence pour la note la plus grave de la tessiture
  set NTESSB [lindex $TESSITURE 2] 
  
# Initialise a zero les listes de doigtes, noms de notes, tessiture/justesse
  lappend lignes_commentaire "0 0"
  set doigtes_notes [list]
  set noms_notes [list]
  set degres_tessiture_notes [list ]
  
# Mise en memoire de chaque doigte
  for {set ifor 0} {$ifor<$NTESSC} {incr ifor} {
    affecte_ligne_num_note doigtes_notes noms_notes degres_tessiture_notes iligne
  }
  
  puts $noms_notes
  puts $degres_tessiture_notes

if {$istutt41>0} {
#Embouchure
#IFLUTE, FCM, FCP, G0; LA0, ALPHA, V0, V1, LEVRES, PAREMB, DECOUV
  lappend lignes_commentaire "0 0"
  affecte_ligne_liste EMBOUCHURE1 iligne 12
  set ifor 0
  foreach iparam [list IFLUTE FCM FCP G0 LA0 ALPHA E0 V0 V1 LEVRES PAREMB DECOUV mreed kreed] {
    set $iparam [lindex $EMBOUCHURE1 $ifor]
    puts "$iparam = [expr $$iparam]"
    incr ifor
  }
#LIBERTE SUR LES PARAMETRES DE L' ANCHE DMA DKA DFCM DFCP DDLEMB
  lappend lignes_commentaire "0 0"
  affecte_ligne_liste EMBOUCHURE2 iligne 5
  set ifor 0
  foreach iparam [list DMA DKA DFCM DFCP DDLEMB] {
    set $iparam [lindex $EMBOUCHURE2 $ifor]
    puts "$iparam = [expr $$iparam]"
    incr ifor
  }
  
  } else {
#Embouchure
#IFLUTE, FCM, FCP, G0; LA0, ALPHA, V0, V1, LEVRES, PAREMB, DECOUV
  lappend lignes_commentaire "0 0"
  affecte_ligne_liste EMBOUCHURE1 iligne 12
  set ifor 0
  foreach iparam [list IFLUTE FCM FCP G0 LA0 ALPHA E0 V0 V1 LEVRES PAREMB DECOUV ] {
    set $iparam [lindex $EMBOUCHURE1 $ifor]
    puts "$iparam = [expr $$iparam]"
    incr ifor
  }
#MREED KREED LBUCC TANDELTA
  lappend lignes_commentaire "0 0"
  affecte_ligne_liste EMBOUCHURE1bis iligne 4
  set ifor 0
  foreach iparam [list mreed kreed LBUCC TANDELTA ] {
    set $iparam [lindex $EMBOUCHURE1bis $ifor]
    puts "$iparam = [expr $$iparam]"
    incr ifor
  }

#LIBERTE SUR LES PARAMETRES DE L' ANCHE DMA DKA DFCM DFCP DDLEMB
  lappend lignes_commentaire "0 0"
  affecte_ligne_liste EMBOUCHURE2 iligne 4
  set ifor 0
  foreach iparam [list DMA DKA DLBUCC DDLEMB] {
    set $iparam [lindex $EMBOUCHURE2 $ifor]
    puts "$iparam = [expr $$iparam]"
    incr ifor
  }
}

#DONNEES CONCERNANT L' AUTO ENTRETIEN GA GB
  lappend lignes_commentaire "0 0"
  affecte_ligne_liste AUTOENTRETIEN iligne 2
  set GA [lindex $AUTOENTRETIEN 0]
  set GB [lindex $AUTOENTRETIEN 1]

if {$istutt41<1} {
# DONNES CONCERNANT LE CALCUL IMPADM (tutt42 uniquement, -1 si impedance, 1 si admittance)
  lappend lignes_commentaire "0 0"
  affecte_ligne_liste IMPADMS iligne 1
  set IMPADM [lindex $IMPADMS 0]
}

#COEFFICIENTS SUR LES CRITERES DE SATISFACTION CJUS CTIM CVOL CEMI CLIB
  lappend lignes_commentaire "0 0"
  affecte_ligne_liste CRITERES iligne 5
  set ifor 0
  foreach iparam [list CJUS CTIM CVOL CEMI CLIB] {
    set $iparam [lindex $CRITERES $ifor]
    puts "$iparam = [expr $$iparam]"
    incr ifor
  }
  # Lignes supplementaires eventuelles : commentaire
  lappend lignes_commentaire "0 0"
  lappend lignes_commentaire "$iligne [expr [llength $entrees]-1]"
#Ajustement temporaire pour simplifier les modifications interactives
lappend D0P 0
lappend DLP 0
lappend LP 0
lappend ISTYLE 0
lappend LEVEE 0

# Verification temporaire des lignes de commentaire
global lignes_commentaire
global entrees
#foreach ii $lignes_commentaire {
#  puts $ii
#  for {set ifor [lindex $ii 0]} {$ifor<[lindex $ii 1]} {incr ifor} {
#    puts [lindex $entrees $ifor]
#  }
#  }
}

# Fin de la fonction de lecture du fichier d'entre
#**************************************************
}

#Espace de travail ddi  l'ecriture/sauvegarde d'un fichier d'entre
#Namespace dedicated to saving/writing as a tutt entry file
namespace eval write_datfile_namespace {

# Ecrire le contenu de la variable mavar sur la ligne en cours
proc ecrire_ligne {mavar} {
  global fsortie
  #puts $mavar
  puts $fsortie $mavar
}

# A partir de la ligne numligne, 
# lire et ignorer toutes les lignes successives contenant du texte,
# affecter a mavar la premiere ligne rencontree ne comptant pas de texte
# la variable numligne indique alors le numero de la ligne suivante
# Le contenu de mavar est renvoye egalement
proc ecrire_ligne_num {mavar} {
  ecrire_ligne $mavar
}

# A partir de la ligne numligneliste, recherche la premiere ligne sans texte
# Affecte toutes les valeurs trouvees sur cette ligne a une liste
# Tant que la liste comporte moins d'elements que nelemliste :
# ajoute toutes les valeurs trouvees sur la prochaine ligne sans texte a la liste
# Une fois le nombre d'elements de la liste superieur ou egal a nelemliste :
# Renvoie la liste, que contient egalement la variable mavarliste
# numligneliste vaut l'indice de la derniere ligne lue +1
proc ecrire_ligne_liste {mavarliste extraspace} {
   variable irange 0
   variable niteml 10
   if {$extraspace>1} {
     ecrire_ligne [regsub {\ } [regsub -all {\}}  [regsub -all {\{} "$mavarliste" ""] ""] "     "]
   } else {
   if {[string length [lindex $mavarliste 0]]>6} {set niteml 7}
   while {[llength $mavarliste]>$irange} {
     #regexp : 
     # {\S+} : mot : recherche de tous (-all) les mots, les renvoyer sous forme de liste (-inline)
     # Reunir la liste obtenue jsuq'ici et cette nouvelle liste
     if {$extraspace>0} {
       variable tmpligne [regsub -all {\}}  [regsub -all {\{} [regsub -all {\ } "[lrange $mavarliste $irange [expr {$irange+$niteml-1}]]" "   "] ""] ""]
       ecrire_ligne " $tmpligne "
     } else {
       ecrire_ligne [regsub -all {\}}  [regsub -all {\{} "[lrange $mavarliste $irange [expr {$irange+$niteml-1}]] " ""] ""]
     }
     incr irange $niteml
     }
     }
}

# Extrait le nom de la note sur la ligne 50 :
#[ regexp -all -inline {\'[^']*\'}  [lindex $entrees 50]]

# Enregistrement en memoire des doigtes :

# A partir de la ligne numligne, 
# lire et ignorer toutes les lignes successives contenant du texte (hors premiere simple quote),
# Une fois une ligne de doigte trouvee, 
#    ajouter le doigte a la liste de doigtes doigtes_notes
#    ajouter le nom de la note  la liste de noms de notes noms_notes
#    ajouter le doublet {degre de tessiture, justesse experimentale} a la liste des degres de tessiture degres_tessiture_notes
# la variable numligne indique alors le numero de la ligne suivante
# Le contenu de la ligne est renvoye egalement
proc ecrire_ligne_num_note {} {
  global refdoigte_notes
  global noms_notes
  global degres_tessiture_notes
  global id_Hole
  variable ifinger
  variable ligne_doigte [list ]
  for {set ifinger 0} {$ifinger<[llength $noms_notes]} {incr ifinger} {
    set ligne_doigte [list ]
    foreach iT [lrange $id_Hole 0 end-1] {
      #Si id_Hole apparait dans le doigte, ajouter 1
      if {[lsearch -exact -integer [lindex $refdoigte_notes $ifinger] $iT]<0} {
        lappend ligne_doigte 1
      } else {
        lappend ligne_doigte 0
      }
    }
    # Utiliser @ pour ajuster les espaces entre chiffres
    set ligne_doigte [regsub -all {\ } "@$ligne_doigte" "@@"]
    lappend ligne_doigte " [lindex $noms_notes $ifinger] [string map {" " "\t"} "[lindex $degres_tessiture_notes $ifinger]"]"
    # Separer les dernieres valeurs par des tabulations
    #lappend ligne_doigte [string map {" " "\t"} "[lindex $degres_tessiture_notes $ifinger]"]
    #ecrire_ligne [string map {@ " "} [regsub {\}} [regsub {\' \{} $ligne_doigte "\' "] ""]]
    ecrire_ligne [string map {@ " "} [regsub {\}} [regsub { \{} $ligne_doigte ""] ""]]
  }
}


# Recherche la prochaine ligne de commentaire
proc ecrire_commentaire_dont_titre {} {
  global entrees
  global fsortie
  global iligne
  global lignes_commentaire
  global titresaisie
  global titre
  variable ifor
  variable ii
  variable tmpligne
  # Recherche prochain commentaire identifie et affichage le cas echeant
  while {[lindex [lindex $lignes_commentaire $iligne] 0]>0} {incr iligne}
  incr iligne
  set ii [lindex $lignes_commentaire $iligne]
  for {set ifor [lindex $ii 0]} {$ifor<[lindex $ii 1]} {incr ifor} {
    set tmpligne [lindex $entrees $ifor]
    if { [string equal $tmpligne $titre] } {
      puts $fsortie $titresaisie
    } else {
      puts $fsortie [lindex $entrees $ifor]
    }
  }
}

# Recherche la prochaine ligne de commentaire
proc ecrire_commentaire {} {
  global entrees
  global fsortie
  global iligne
  global lignes_commentaire
  variable ifor
  variable ii
  # Recherche prochain commentaire identifie et affichage le cas echeant
  while {[lindex [lindex $lignes_commentaire $iligne] 0]>0} {incr iligne}
  incr iligne
  set ii [lindex $lignes_commentaire $iligne]
  for {set ifor [lindex $ii 0]} {$ifor<[lindex $ii 1]} {incr ifor} {
    puts $fsortie [lindex $entrees $ifor]
  }
}


# ECRITURE
proc save_to_filename {output_dat_filename} {
  variable lesglobales {entrees nlignesentree paramphy titre titresaisie istutt41 istutt42 premiereligne
  N C1 D0 DL OFILIB 
  osc_par_k osc_par_M osc_par_K osc_par_Nu RIGID
  L Temperature D0P DLP LP 
  ISTYLE LEVEE FLA ITMPNT 
  NTESSC NTESSG  NTESSB 
  doigtes_notes noms_notes degres_tessiture_notes 
  IFLUTE FCM FCP G0 LA0 ALPHA E0 V0 V1 LEVRES PAREMB DECOUV mreed kreed LBUCC TANDELTA
  DMA DKA DFCM DFCP DLBUCC DDLEMB
  GA GB
  IMPADM
  CJUS CTIM CVOL CEMI CLIB}

  foreach tmpvar $lesglobales {
    global $tmpvar
  }

#Ouverture du fichier d'entree choisi
  global fsortie
  set fsortie [open "$output_dat_filename" w]

# Reecrire le fichier de sortie comme le dernier fichier d'entree lu 

  global iligne
  set iligne 0
  
# Premiere ligne : titre si <tutt41
  if {$istutt41<1} {
    ecrire_ligne $premiereligne
  } else {
    ecrire_ligne $titresaisie
  }

# Init lignes de commentaire
  
# Parametres physiques
  if {$istutt41<1} {
  puts "ECRIRE COMMENTAIRE DONT TITRE"
    ecrire_commentaire_dont_titre
  } else {
    ecrire_commentaire
  }
  ecrire_ligne_num $paramphy
  
# N : Nombre de troncons-1
  ecrire_commentaire
  ecrire_ligne_num [expr {[llength $D0]-1}]

# C1 : Tube ouvert (0) ou ferme (1)
  ecrire_commentaire
  ecrire_ligne_num $C1

#D0 : Diametres des debuts de troncons
  ecrire_commentaire
  ecrire_ligne_liste $D0 0
#DL : Diametres des fins de troncons
  ecrire_commentaire
  ecrire_ligne_liste $DL 0
  
#Rugosite :
#OFILIB : Rapports entre surface libre reelle de la perce et surface libre macroscopique
  ecrire_commentaire
  ecrire_ligne_liste $OFILIB 0

if {$istutt42>0} {
  ecrire_commentaire
  variable osc_PAR [list $osc_par_k $osc_par_M $osc_par_K $osc_par_Nu]
  ecrire_ligne_liste $osc_PAR 0
  ecrire_commentaire
  ecrire_ligne_liste $RIGID 0
}

#L : Longueurs des troncons
  ecrire_commentaire
  ecrire_ligne_liste $L 0
  
#Temperature en haut du tube et en bas du tube (degres celcius)
  ecrire_commentaire
  ecrire_ligne_liste $Temperature 0
  
#D0P : Diametres des debuts de cheminees laterales
  ecrire_commentaire
  ecrire_ligne_liste [lrange $D0P 0 end-1] 0
#DLP : Diametres des fins de cheminees laterales
  ecrire_commentaire
  ecrire_ligne_liste [lrange $DLP 0 end-1] 0
#LP : Hauteurs des cheminees laterales
  ecrire_commentaire
  ecrire_ligne_liste [lrange $LP 0 end-1] 0
  
#ISTYLE : Styles des cles des trous lateraux (0 : pas de cle, 1 : plateau creux, 2 :plateau plein)
  ecrire_commentaire
  ecrire_ligne_liste [lrange $ISTYLE 0 end-1] 1
#LEVEE : Levees des cles (hauteur de la cle levee au dessus de la cheminee)
  ecrire_commentaire
  ecrire_ligne_liste [lrange $LEVEE 0 end-1] 0
  
#FLA : Frequence du 'la' de reference
  ecrire_commentaire
  ecrire_ligne_num $FLA
#ITMPNT : Donne le temperament de reference (1 : egal a octaves justes, 0 : egal a quintes justes)
  ecrire_commentaire
  ecrire_ligne_num $ITMPNT
  
#Tessiture
  variable TESSITURE [list $NTESSC $NTESSG $NTESSB]
  ecrire_commentaire
  ecrire_ligne_liste $TESSITURE 1
#NTESSC : Nombre total de notes etudiees
#NTESSG : Nombre de demi-tons contenus dans la tessiture
#NTESSB : Nombre de demi-tons au dessous du 'la' de refrence pour la note la plus grave de la tessiture
  
# Initialise a zero les listes de doigtes, noms de notes, tessiture/justesse
  #set doigtes_notes [list]
  #set noms_notes [list]
  #set degres_tessiture_notes [list]
  
# Mise en memoire de chaque doigte
  #for {set ifor 0} {$ifor<$NTESSC} {incr ifor} {
  ecrire_commentaire
  ecrire_ligne_num_note 
    #doigtes_notes noms_notes degres_tessiture_notes iligne
  #}
  
  #puts $noms_notes
  #puts $degres_tessiture_notes
if {$istutt41>0} { 
#Embouchure
#IFLUTE, FCM, FCP, G0; LA0, ALPHA, E0, V0, V1, LEVRES, PAREMB, DECOUV
  variable EMBOUCHURE1 [list $IFLUTE $FCM $FCP $G0 $LA0 $ALPHA $E0 $V0 $V1 $LEVRES $PAREMB $DECOUV $mreed $kreed]
  ecrire_commentaire
  ecrire_ligne_liste $EMBOUCHURE1 2

#LIBERTE SUR LES PARAMETRES DE L' ANCHE DMA DKA DFCM DFCP DDLEMB
  variable EMBOUCHURE2 [list $DMA $DKA $DFCM $DFCP $DDLEMB]
  ecrire_commentaire
  ecrire_ligne_liste $EMBOUCHURE2 0
   } else {
  #Embouchure
#IFLUTE, FCM, FCP, G0; LA0, ALPHA, E0, V0, V1, LEVRES, PAREMB, DECOUV
  variable EMBOUCHURE1 [list $IFLUTE $FCM $FCP $G0 $LA0 $ALPHA $E0 $V0 $V1 $LEVRES $PAREMB $DECOUV]
  ecrire_commentaire
  ecrire_ligne_liste $EMBOUCHURE1 2
  
  variable EMBOUCHURE1bis [list $mreed $kreed $LBUCC $TANDELTA]
  ecrire_commentaire
  ecrire_ligne_liste $EMBOUCHURE1bis 0

#LIBERTE SUR LES PARAMETRES DE L' ANCHE DMA DKA DFCM DFCP DDLEMB
  variable EMBOUCHURE2 [list $DMA $DKA $DLBUCC $DDLEMB]
  ecrire_commentaire
  ecrire_ligne_liste $EMBOUCHURE2 0

  }

#DONNEES CONCERNANT L' AUTO ENTRETIEN GA GB
  variable AUTOENTRETIEN [list $GA $GB]
  ecrire_commentaire
  ecrire_ligne_liste $AUTOENTRETIEN 0

if {$istutt41<1} {
# DONNEES CONCERNANT LE CALCUL IMPADM (-1 si impdance, 1 si impdance)
  ecrire_commentaire
  ecrire_ligne_num $IMPADM
  puts "*** $IMPADM"
}
#COEFFICIENTS SUR LES CRITERES DE SATISFACTION CJUS CTIM CVOL CEMI CLIB
  variable CRITERES [list $CJUS $CTIM $CVOL $CEMI $CLIB]
  ecrire_commentaire
  ecrire_ligne_liste $CRITERES 0
  #Ecrire dernieres lignes
  ecrire_commentaire
  close $fsortie
}
# Fin de la fonction d'ecriture du fichier de sortie
#***************************************************
}

# Fusionne les tronons iT1 et iT1+1
# Merge sections iT1 and iT1+1
proc merge_sections {iT1} {
  global L
  variable ilist
  variable iT2 [expr $iT1+1]
  if {$iT2>=[expr [llength $L]]} return
  if {$iT1<0} return
  variable lesvars {D0 DL L D0P DLP LP ISTYLE LEVEE OFILIB id_Area_Section id_Contour_Section id_Interface id_Hole id_Key id_Area_HoleSection}
  foreach ilist $lesvars {
  global "$ilist"
  }
  # Si un trou est prsent, ne pas fusionner
  # If non zero hole, do not merge
  if  {[lindex $D0P $iT1]>0} {
    tk_messageBox -message "Supprimer d'abord le trou  l'interface des tronons  fusionner !" -type ok
    return
  }
  # Si un dcrochement existe, ne pas fusionner
  # If diameter discontinuity, do not merge
  if  {[expr abs([lindex $D0 $iT1]-[lindex $DL $iT2])]>0} {
    tk_messageBox -message "Diamtres diffrents  l'interface des tronons  fusionner :\n\nSupprimer le dcrochement avant de fusionner les tronons" -type ok
    return
  }
  geofingeringchanged
  global id_Area_SectionHole
  lset L $iT2 [expr {[lindex $L $iT1]+[lindex $L $iT2]}]
  lset DL $iT2 [lindex $DL $iT1]
  .maincanvas delete "H[lindex $id_Hole $iT1]"
  variable lesvars2 {{id_Area_Section .maincanvas} {id_Contour_Section .maincanvas}}
  foreach ilist "$lesvars2" {
    global "[lindex $ilist 0]"
    [lindex "$ilist" 1] delete [lindex [set [lindex "$ilist" 0]] "$iT1"]
  }

  foreach ilist $lesvars {
  set "$ilist" [lreplace [set "$ilist"] "$iT1" "$iT1"]
  }
  set id_Area_SectionHole [lreplace $id_Area_SectionHole "$iT2" "$iT2"]
  retrace
}

# Scinde le tronon courant en deux, se place sur le nouveau tronon d'indice le plus lev
#Split current section in two sections, the new current part being the highest index part of the created parts
proc split_section {{iT} Linew} {
  global section_index
  variable ilist
  variable ilist2
  variable letype
  variable lesvars {D0 DL L D0P DLP LP ISTYLE LEVEE OFILIB}
  foreach ilist $lesvars {
  global "$ilist"
  }
  global id_Contour_Section
  set Linew 0
  variable Lold [lindex $L $iT]
  variable ifor  $iT
  variable iTp1
  set iTp1 [expr {$iT+1}]
  if {$Linew==0} {set Linew [expr {1.0*$Lold/2}]}
  # To avoid cumulative rounding errors, round Linew before computing Li1new so that the sum value is kept with the same precision
  global unitL
  set Linew [expr {1.0*[printmm [list "$Linew"] 0]/$unitL}]
  puts $Linew
  variable Li1new [expr {$Lold-$Linew}]
  # If one resulting width is rounded to zero, don't split
  if {[expr {$Linew*$Li1new}]>0} {
    variable lesvars2 {{id_Area_Section .maincanvas} {id_Contour_Section .maincanvas} {id_Hole .maincanvas} 
    {id_Key .maincanvas} {id_Area_SectionHole .maincanvas} {id_Area_HoleSection .maincanvas} {id_Interface .maincanvas} }
  foreach ilist "$lesvars2" {
    global "[lindex $ilist 0]"
    # Quel est le type d'objet a cloner ? (rectangle, line, polygon, ...)
    # Which object type to clone ? (rectangle, line, polygon,...)
    set letype [[lindex "$ilist" 1] type [lindex [set [lindex $ilist 0]] $ifor]]
    # Creer un objet de base pour avoir un numero a inserer
    # Create base object to get a unique number to insert
    set [lindex $ilist 0] [linsert [set [lindex $ilist 0]] $iT [ [lindex "$ilist" 1] create  $letype 0 0 1 1]]
    # Cloner les proprietes correspondant au troncon initial sur chaque objet ainsi cr
    # For each new created object, clone the properties from the initial section
    foreach ilist2 [[lindex "$ilist" 1] itemconfigure [lindex [set [lindex $ilist 0]] $iTp1]] {
      [lindex "$ilist" 1] itemconfigure [lindex [set [lindex $ilist 0]] $ifor] [lindex $ilist2 0] [lindex $ilist2 4]
    }
    # Ne pas cloner les tags
    # Don't clone tags
    [lindex "$ilist" 1] itemconfigure [lindex [set [lindex $ilist 0]] $ifor] -tags ""
  }
  foreach ilist $lesvars {
    set "$ilist" [linsert [set "$ilist"] $iT [lindex [set "$ilist"] "$iT"]]
  }
  lset L $iT $Linew
  lset L $iTp1 $Li1new
  variable D01 [lindex $D0 $iT]
  variable DL1 [lindex $DL $iT]
  variable nD [expr {(1.0*$D01*$Linew+$DL1*$Li1new)/$Lold}]
  lset D0 $iT $nD
  lset DL $iTp1 $nD
  foreach ilist {D0P DLP LP  LEVEE} {
    lset $ilist $iT 0.
  }
  lset ISTYLE $iT 0
  
# Intervertir les demi rectangles TronconsTrou (original et clone -> clone et original) pour n'en avoir qu'un seul  reconfigurer (clone)
# Swap half rectangles SectionHole, original and clone (keeping their IDs) to have only one half rectangle to reconfigure
  set id_Area_SectionHole [lreplace $id_Area_SectionHole $ifor $iTp1 [lindex $id_Area_SectionHole $iTp1] [lindex $id_Area_SectionHole $ifor]]
  
  variable txtifor "\[lsearch -exact \$id_Area_Section [lindex $id_Area_Section $ifor]\]"
  .maincanvas bind [lindex $id_Area_Section $ifor] <1> "
  focus .
  edit_section section_index \"$txtifor\"
  raise .editsectiongeo
  focus .editsectiongeo"
  .maincanvas bind [lindex $id_Contour_Section $ifor] <1> "
  focus .
  edit_section section_index \"$txtifor\"
  raise .editsectiongeo
  focus .editsectiongeo"
  .maincanvas bind [lindex $id_Area_Section $ifor] <Enter> "variable tifor $txtifor
  .status_bar configure -text  \"Tronon \[expr {\$tifor+1}\] :   Longueur  \[format %%G \[expr {\$unitL*\[lindex \$L \$tifor\]}\]\]   Diamtre initial \[format %%G \[expr {\$unitL*\[lindex \$D0 \$tifor\]}\]\]   Diamtre final \[format %%G \[expr {\$unitL*\[lindex \$DL \$tifor\]}\]\]\""

  .maincanvas addtag H[lindex $id_Hole $ifor] withtag "[lindex $id_Area_HoleSection $ifor]"
  .maincanvas addtag H[lindex $id_Hole $ifor] withtag "[lindex $id_Area_SectionHole $iTp1]"
  .maincanvas lower H[lindex $id_Hole $ifor] 
  foreach ifor2 "[lindex $id_Hole $ifor] [lindex $id_Interface $ifor] [lindex $id_Key $ifor]" {
    .maincanvas addtag H[lindex $id_Hole $ifor] withtag $ifor2
  }
# Comportement identique si l'on clique  gauche,  droite de l'interface, sur l'interface ou sur le trou
  variable txtifor "\[lsearch -exact \$id_Hole [lindex $id_Hole $ifor]\]"
  .maincanvas bind H[lindex $id_Hole $ifor] <1> "
  focus .
  edit_hole hole_index \"$txtifor\"
  raise .editholegeo
  focus .editholegeo"
  .maincanvas bind H[lindex $id_Hole $ifor] <Enter> "variable tifor $txtifor
  .status_bar configure -text \"Trou \[expr {\$tifor+1}\] :   Hauteur chemine \[format %%G \[expr {\$unitL*\[lindex \$LP \$tifor\]}\]\]   Diamtre Extrieur \[format %%G \[expr {\$unitL*\[lindex \$D0P \$tifor\]}\]\]   Diamtre Intrieur \[format %%G \[expr {\$unitL*\[lindex \$DLP \$tifor\]}\]\]\"
  handcursor .maincanvas"
  .maincanvas bind H[lindex $id_Hole $ifor] <Leave> "defaultcursor .maincanvas"
  
  #variable txtifor "\[lsearch -exact \$id_Contour_Section [lindex $id_Contour_Section $ifor]\]"
  #.maincanvas bind [lindex $id_Contour_Section $ifor] <1> " .editsectiongeo.monlabel configure -text \"generatrice $txtifor\""
  #.maincanvas bind [lindex $id_Contour_Section $ifor] <Enter> ".status_bar configure -text \"generatrice $txtifor\""
  puts $section_index
  edit_section section_index $iTp1
  geofingeringchanged
  retrace
  }
}

proc modify_section {} {
  global unitL
  foreach ilist {D0 DL L OFILIB section_index curd0 curdl curl curofilib chkD0 chkDL choice_L_change} {
    global $ilist
  }

  variable iTm1 [expr {$section_index-1}]
  # Application aux tronons voisins
  if {$section_index>0} {
  # Si diamtre voisin asservi :
    if {$chkDL>0} {
      lset D0 $iTm1 [format %G [expr {1.0*$curdl/$unitL}]]
    }
    if {$choice_L_change<0} {
      # Longueur voisine asservie
      lset L  $iTm1 [expr {[lindex $L $section_index]+[lindex $L $iTm1]-[format %G [expr {1.0*$curl/$unitL}]]}]
    }
  }
  variable iTm1 [expr {$section_index+1}]
  if {$iTm1<[llength $L]} {
  # Si diamtre voisin asservi :
  if {$chkD0>0} {
    lset DL $iTm1 [format %G [expr {1.0*$curd0/$unitL}]]
  }
  if {$choice_L_change>0} {
      # Longueur voisine asservie
      lset L  $iTm1 [expr {[lindex $L $section_index]+[lindex $L $iTm1]-[format %G [expr {1.0*$curl/$unitL}]]}]
    }
  }
  
  lset D0 $section_index [format %G [expr {1.0*$curd0/$unitL}]]
  lset DL $section_index [format %G [expr {1.0*$curdl/$unitL}]]
  lset L  $section_index [format %G [expr {1.0*$curl/$unitL}]]
  lset OFILIB $section_index $curofilib
  geofingeringchanged
  retrace
  edit_section section_index $section_index
}

set wgeo_eh ""

toplevel .editholegeo
wm title .editholegeo {Edition Geometrie}
wm protocol .editholegeo WM_DELETE_WINDOW {
  set wgeo_eh "[wm geometry .editholegeo]"
  wm withdraw .editholegeo
}

set wgeo_et ""

toplevel .editsectiongeo 
wm title .editsectiongeo {Edition Geometrie}
wm protocol .editsectiongeo WM_DELETE_WINDOW {
  set wgeo_et "[wm geometry .editsectiongeo]"
  wm withdraw .editsectiongeo
}

#*************************************************
# Construction de l'interface d'dition de tronon

set irow -1

set section_index 1
set section_indexP1 2

set esg .editsectiongeo

grid [tk::frame  $esg.numerotroncon] -column 2 -row [incr irow]
grid [tk::label  $esg.numerotroncon.label_Section -text "Tronon N" -font {-size -20}] -column 0 -row 0
grid [ttk::combobox $esg.numerotroncon.section_indexbox -values  [list  1 2 3] -state readonly -textvariable section_indexP1 -width 3 -font {-size -20}] -column 1 -row 0

grid [tk::button $esg.prevsection -background $leftcolor]  -column 0 -row $irow
grid [tk::frame  $esg.mergeleftbg]                        -column 1 -row $irow -sticky nwes
grid [tk::label  $esg.mergeleftbg.mergeleftbgg -background $leftcolor] -column 0 -row 0 -sticky nwes
grid [tk::label  $esg.mergeleftbg.mergeleftbgd -background white]     -column 1 -row 0 -sticky nwes
grid [tk::button $esg.mergeleft]                          -column 1 -row $irow
grid [tk::frame  $esg.mergerightbg]                        -column 3 -row $irow -sticky nwes
grid [tk::label  $esg.mergerightbg.mergerightbgg -background white]      -column 0 -row 0 -sticky nwes
grid [tk::label  $esg.mergerightbg.mergerightbgd -background $rightcolor] -column 1 -row 0 -sticky nwes
grid [tk::button $esg.mergeright]                          -column 3 -row $irow
grid [tk::button $esg.nextsection -background $rightcolor] -column 4 -row $irow

 bind $esg.numerotroncon.section_indexbox  <<ComboboxSelected>> {
   after idle [edit_section section_index [expr {$section_indexP1-1}]]
 }
 $esg.prevsection configure -command "edit_section section_index \[expr {\$section_index+1}\]"
 $esg.nextsection configure -command "edit_section section_index \[expr {\$section_index-1}\]"

grid [tk::frame  $esg.fdiamdlg -background $leftcolor] -sticky se -rowspan 2 -column 0 -row [incr irow]
grid [tk::label  $esg.fdiamdlg.diamdlg -background $leftcolor -text "Diamtre Final\ntronon de gauche"] -sticky e -column 0 -row 0
grid [tk::label  $esg.diamd0 -text "Diamtre Initial :"]           -column 1 -row $irow

grid [tk::label  $esg.diamdl -text "Diamtre Final :"]             -column 3 -row $irow
grid [tk::frame  $esg.fdiamd0d -background $rightcolor] -sticky sw -rowspan 2 -column 4 -row $irow
grid [tk::label  $esg.fdiamd0d.diamd0d -background $rightcolor -text "Diamtre Initial\ntronon de droite"] -sticky w -column 0 -row 0

 $esg.mergeleft configure -command "merge_sections \$section_index
edit_section section_index \$section_index"

 $esg.mergeright configure -command "merge_sections \[expr {\$section_index-1}\]
edit_section section_index \[expr {\$section_index-1}\]"

grid [tk::label  $esg.fdiamdlg.diamdlgval -background $leftcolor] -sticky es  -column 0 -row 2

# Diamtre initial
grid [tk::frame  $esg.framediam0] -column 1 -row [incr irow]
grid [tk::button $esg.framediam0.diamdlgcopy -text "= adjacent\n-- >"] -column 0 -row 0
grid [tk::spinbox $esg.framediam0.spind0 -from 0.1 -to $unitL -increment $uincrement -format $precision -width 6 -textvariable curd0 -font $fontspin -justify right] -column 1 -row 0

 $esg.framediam0.diamdlgcopy configure -command {set curd0 [ $esg.fdiamdlg.diamdlgval  cget -text]}

# Diamtre final
grid [tk::frame  $esg.framediaml] -column 3 -row $irow
grid [tk::spinbox $esg.framediaml.spindl -from 0.1 -to $unitL -increment $uincrement -format $precision -width 6 -textvariable curdl -font $fontspin -justify right] -column 0 -row 0
grid [tk::button $esg.framediaml.diamd0dcopy -text "= adjacent\n< --"] -column 1 -row 0

 $esg.framediaml.diamd0dcopy configure -command {set curdl [ $esg.fdiamd0d.diamd0dval  cget -text]}

grid [tk::label  $esg.fdiamd0d.diamd0dval -background $rightcolor] -sticky ws -column 0 -row 2

# Appliquer ou non aux diamtres adjacent
grid [tk::checkbutton $esg.checkD0 -text "Appliquer aussi au Diamtre Final du tronon de gauche\n la nouvelle valeur pour ne pas crer de dcrochement" -variable chkD0]   -column 0 -columnspan 2 -row [incr irow]
grid [tk::checkbutton $esg.checkDL -text "Appliquer aussi au Diamtre Initial du tronon de droite\n la nouvelle valeur pour ne pas crer de dcrochement" -variable chkDL] -column 3 -columnspan 2 -row $irow

# Longueur tronon

grid [tk::frame $esg.insertlong] -column 2 -rowspan 3 -row [incr irow -2] -sticky nwes
incr irow
grid [tk::button $esg.insertlong.split_section -text "o o Scinder ce tronon" -command "
split_section \$section_index 0
edit_section section_index \$section_index"
] -column 1 -row 0 -sticky n

grid [tk::label       $esg.insertlong.labelLT -text "Longueur du tronon :"]    -column 1 -row 2 -sticky wes
grid [tk::spinbox $esg.insertlong.spinl -from 0.1 -to $unitL -increment $uincrement -format $precision -width 6 -textvariable curl -font $fontspin -justify right] -column 1 -row 3 -sticky s
grid [ttk::separator  $esg.insertlong.separLHl -orient vertical] -rowspan 2 -column 0 -row 2 -sticky nws
grid [ttk::separator  $esg.insertlong.separLHr -orient vertical] -rowspan 2 -column 2 -row 2 -sticky nes


grid columnconfigure $esg.insertlong 1 -weight 1
grid rowconfigure $esg.insertlong 0 -weight 1
grid rowconfigure $esg.insertlong 1 -weight 0
grid rowconfigure $esg.insertlong 2 -weight 1
grid rowconfigure $esg.insertlong 3 -weight 1
#grid columnconfigure $esg 1 -weight 0

set choice_L_change 0
set slopequaltext "Changer les diamtres  l'interface des \ntronons modifis, pour avoir la mme \npente de part et d'autre de cette interface"

grid [ttk::separator  $esg.separLTl -orient horizontal] -columnspan 2 -column 0 -row [incr irow 2] -sticky nwes
grid [ttk::separator  $esg.separLTr -orient horizontal] -columnspan 2 -column 3 -row $irow -sticky nwes
grid [tk::radiobutton $esg.l_avec_total  -text "Modifier la LONGUEUR TOTALE de l'instrument de la mme valeur, sans changer les autres tronons" -variable choice_L_change -value 0]                          -columnspan 3 -column 0 -row  [incr irow] -sticky w
grid [tk::button $esg.slopequal -text $slopequaltext -command "equalize_slope"] -column 3 -row $irow -rowspan 3 -columnspan 2
grid [tk::radiobutton $esg.l_avec_gauche -text "Modifier le TRONON DE GAUCHE de la valeur oppose, pour garder la longueur totale constante"    -variable choice_L_change -value 1  -background $leftcolor]  -columnspan 3 -column 0 -row [incr irow] -sticky w
grid [tk::radiobutton $esg.l_avec_droite -text "Modifier le TRONON DE DROITE de la valeur oppose, pour garder la longueur totale constante"    -variable choice_L_change -value -1 -background $rightcolor] -columnspan 3 -column 0 -row [incr irow] -sticky w

$esg.l_avec_total configure -command "$esg.slopequal configure -state disable"
foreach ifor {l_avec_gauche l_avec_droite} {
  $esg.$ifor configure -command "$esg.slopequal configure -state normal"
}

set choice_L_change 0

grid [tk::frame $esg.fofilib] -column 1 -columnspan 3 -row [incr irow]
grid [tk::label $esg.fofilib.lofilib -text "Rugosit : OFILIB = Primtre/(Pi.Diamtre) = "] -column 0 -row 0
set curofilib 0
grid [tk::entry $esg.fofilib.eofilib -textvariable curofilib -width 5 -justify right] -column 1 -row 0


grid [tk::frame  $esg.changesT] -column 1 -columnspan 3 -row [incr irow]
grid [tk::button $esg.changesT.changeTroncon -text "Appliquer les changements"] -sticky nwes -column 2 -row 0
grid [tk::button $esg.changesT.nochangeTroncon -text "Annuler les changements"] -sticky nwes -column 3 -row 0

grid [tk::button $esg.help -text "?" -command "open_help_window {geometry}"]  -column 0 -row $irow

 $esg.changesT.changeTroncon configure -command {modify_section}
 $esg.changesT.nochangeTroncon configure -command {edit_section section_index $section_index}


grid columnconfigure $esg 0 -weight 0
foreach ifor {0 1 2 3 4 5 6} {
  grid rowconfigure $esg $ifor -weight 0
}

grid rowconfigure    $esg.numerotroncon 0 -weight 0
grid columnconfigure $esg.numerotroncon 0 -weight 0

foreach ifor {
mergeleftbg mergeleftbg.mergeleftbgd mergeleftbg.mergeleftbgg
mergerightbg mergerightbg.mergerightbgd mergerightbg.mergerightbgg} {
  grid columnconfigure $esg.$ifor 0 -weight 1
}

grid columnconfigure $esg.mergeleftbg 1 -weight 1
grid rowconfigure $esg.mergeleftbg 0 -weight 1

grid columnconfigure $esg.mergerightbg 1 -weight 1
grid rowconfigure $esg.mergerightbg 0 -weight 1

set section_index 1
set id_pressure -1

wm withdraw $esg

# Fin de la construction de l'interface d'dition de tronon
#***********************************************************

# Renvoie la "indice"-ime valeur de "liste", en mm, arrondie au 1/10e de mm
proc printmm {liste indice} {
  global unitL
  global precision
  return [format $precision  [expr {$unitL*[lindex $liste $indice]}]]
}


proc equalize_slope {} {
  foreach ilist {L D0 DL section_index section_indexP1 
  choice_L_change chkD0 chkDL
  curl curd0 curdl unitL} {
    global $ilist
  }
  variable action_valid
  set action_valid 0
  # Left or right ?
  set u $section_index
  if {$choice_L_change>0} {
    if {$section_indexP1<[llength $L]} {
      if {$chkD0>0} {
        incr action_valid
      } else {
        tk_messageBox -message "La case garantissant l'absence de dcrochement avec le tronon de gauche doit tre coche pour autoriser cette mise  jour du diamtre initial."
      }
    }
  } else {
    if {$section_index>0} {
      if {$chkDL>0} {
        incr action_valid
	incr u -1
      } else {
        tk_messageBox -message "La case garantissant l'absence de dcrochement avec le tronon de droite doit tre coche pour autoriser cette mise  jour du diamtre final."
      }
    }
  }
  if {$action_valid>0} {
    set v $u
    incr v
    set Lsum [::tcl::mathop::+ {*}[lrange $L $u $v]]
    set dg [lindex $D0 $v]
    set dd [lindex $DL $u]
    set nL2 [format %G [expr {2.0*$curl/$unitL-$Lsum}]]
    set nL2b $nL2
    set nc 1
    if {$nL2<0} {
      incr nc -2
    }
    #set doffset [expr {(($dd-$dg)*($nL2b-$Lsum)/(2*$Lsum)}]
    #set di [expr {$dd-$choice_L_change*$nc*$doffset}]
    set di [printmm [list "[expr {($dg+$dd)/2-$nL2*$choice_L_change*($dd-$dg)/(2.0*$Lsum)}]"] 0]
    #set di2 [expr ($dg+$dd)/2-$nL2*$choice_L_change*($dd-$dg)/(2.0*$Lsum)]
    #tk_messageBox -message "dg dd $dg $dd\nLsum $Lsum nL2 $nL2\n$di\n$di2\n$nc\n$choice_L_change"
    if {$choice_L_change>0} {
      set curd0 $di
    } else {
      set curdl $di
    }    
  }
}


#*****************************************************************************************************
# Mise  jour des champs de l'interface d'dition de tronon lorsqu'un nouveau tronon est slectionn
proc edit_section {section_indexvar valeur} {
  upvar 1 $section_indexvar section_index
  
  foreach ilist {L D0 DL OFILIB section_indexP1 choice_L_change
  leftcolor rightcolor
  curd0 curdl curl curofilib 
  chkD0 chkDL ISTYLE
  id_Area_Section hole_index id_Area_SectionHole id_Area_HoleSection id_Hole hole_index
  wgeo_et wgeo_eh} {
    global "$ilist"
  }
  .maincanvas itemconfigure HO[lindex $id_Hole $hole_index] -outline black -width [expr {1+([lindex $ISTYLE $hole_index]>0)*2}] -dash {}
  if {[string match {normal} [wm state .editholegeo]]} {
    set wgeo_eh "[wm geometry .editholegeo]"
  }
  if {[string match {normal} [wm state .editsectiongeo]]} {
    set wgeo_et "[wm geometry .editsectiongeo]"
  }
  wm withdraw .editholegeo
  
  variable iTm1 [expr {$hole_index+1}]
  foreach ifor "
  [lindex $id_Area_HoleSection $hole_index]
  [lindex $id_Area_SectionHole $hole_index]
  [lindex $id_Area_SectionHole $iTm1]
  [lindex $id_Area_HoleSection $iTm1]
  [lindex $id_Area_Section $section_index]" {
    .maincanvas itemconfigure $ifor -fill lightgrey
  }
  
  if {$valeur>=[llength $L]} {
    set valeur [expr {[llength $L]-1}]
  }
  if {$valeur<0} {
    set valeur 0
  }
  set iTm1 [expr {$section_index-1}]
  if {$iTm1>-1} {
    .maincanvas itemconfigure [lindex $id_Area_Section $iTm1] -fill lightgrey
  }
  set iTm1 [expr {$section_index+1}]
  if {$iTm1<[llength $L]} {
    .maincanvas itemconfigure [lindex $id_Area_Section $iTm1] -fill lightgrey
  }
  .editsectiongeo.slopequal configure -state disable
  if {abs($choice_L_change)>0} {
    .editsectiongeo.slopequal configure -state normal
  }
  set section_index $valeur
  set section_indexP1 $valeur
  incr section_indexP1
  
  .editsectiongeo.numerotroncon.section_indexbox configure -values [lsearch -all -not -start 1 "$L 0" "NaN" ]
  
  set iTm1 [expr {$section_index-1}]
  .editsectiongeo.mergeright configure -text "Fusionner tronons N$section_indexP1 et $section_index"
  .editsectiongeo.nextsection configure -text "Editer \nTronon n$section_index"
  if {$iTm1<0} {
    .editsectiongeo.nextsection   configure -text "Extrmit\nTronon n$section_index"
     .editsectiongeo.fdiamd0d.diamd0dval configure -text [printmm $DL $section_index]
     set iTm1 $section_index
  } else {
     .editsectiongeo.fdiamd0d.diamd0dval configure -text [printmm $D0 $iTm1]
     .maincanvas itemconfigure [lindex $id_Area_Section $iTm1] -fill $rightcolor
  }
  # .editsectiongeo.nextsection configure -command "edit_section section_index $iTm1"
  
  set iTm1 [expr {$section_index+1}]
  set valeur $section_indexP1
  incr valeur
  .editsectiongeo.prevsection configure -text "Editer \nTronon n$valeur"
  .editsectiongeo.mergeleft configure -text "Fusionner tronons N$valeur et $section_indexP1"
  if {$iTm1<[llength $L]} {
    .editsectiongeo.fdiamdlg.diamdlgval configure -text [printmm $DL $iTm1]
    .maincanvas itemconfigure [lindex $id_Area_Section $iTm1] -fill $leftcolor
  } else {
    .editsectiongeo.prevsection  configure -text "Extrmit\nTronon n$section_indexP1"
    .editsectiongeo.fdiamdlg.diamdlgval configure -text [printmm $D0 $section_index]
    set iTm1 $section_index
  }
  # .editsectiongeo.prevsection configure -command "edit_section section_index $iTm1"
  
  .maincanvas itemconfigure [lindex $id_Area_Section $section_index] -fill white
  
  set curd0 [printmm $D0 $section_index]
  set curdl [printmm $DL $section_index]
  set curl  [printmm $L $section_index]
  set curofilib [lindex $OFILIB $section_index]
  
  # Si le diametre adjacent est identique, pre-cocher la case liant les diametres correspondants
  set chkD0 1
  set chkDL 1
  if {[string compare $curd0 [ .editsectiongeo.fdiamdlg.diamdlgval cget -text]]} {set chkD0 0}
  if {[string compare $curdl [ .editsectiongeo.fdiamd0d.diamd0dval cget -text]]} {set chkDL 0}
  wm deiconify .editsectiongeo
  wm geometry .editsectiongeo [regsub {^[^x]*x[0-9]*([^0-9])} $wgeo_et {\1}]
}
# Fin de la mise  jour des champs de l'interface d'dition de tronon lorsqu'un nouveau tronon est slectionn
#***************************************************************************************************************

#**********************************************
# Construction de l'interface d'dition de trou
set irow -1
grid [tk::button .editholegeo.trouprec -background $leftcolor] -column 0 -row [incr irow]
grid [tk::label  .editholegeo.troncgt  -background $leftcolor] -column 1 -row $irow
grid [tk::frame  .editholegeo.numerotrou] -column 2 -row $irow
grid [tk::label  .editholegeo.troncdt -background $rightcolor] -column 3 -row $irow
grid [tk::label  .editholegeo.numerotrou.labelTrou -text "Trou N" -font {-size -20}] -column 0 -row 0
grid [ttk::combobox .editholegeo.numerotrou.combotrou -values [list 1 2 3] -textvariable hole_indexP1 -state readonly -width 3 -font {size -20}] -column 1 -row 0
grid [tk::button .editholegeo.trousuiv -background $rightcolor] -column 4 -row $irow

.editholegeo.trouprec configure -command "edit_hole hole_index \[expr {\$hole_index+1}\]"
.editholegeo.trousuiv configure -command "edit_hole hole_index \[expr {\$hole_index-1}\]"

 bind .editholegeo.numerotrou.combotrou <<ComboboxSelected>> {
   after idle [edit_hole hole_index [expr {$hole_indexP1-1}]]
 }

grid [tk::button .editholegeo.supprTrou -text "X Supprimer ce trou"] -column 3  -columnspan 2 -rowspan 2 -row [incr irow] -sticky s

grid [tk::frame  .editholegeo.frameiflute] -column 0 -row $irow -rowspan 5 -sticky nwes
grid [tk::label  .editholegeo.labeltroupdf -text "Diamtre Intrieur :"] -column 2 -row $irow -sticky s
grid [tk::spinbox .editholegeo.spinpdf -from 0.0 -to $unitL -increment $uincrement -format $precision -width 6 -textvariable pdf -font $fontspin -justify right] -column 2 -row [incr irow]

grid [tk::label  .editholegeo.labeltrouh -text "Hauteur chemine :"] -column 1 -row $irow -sticky s
grid [tk::spinbox .editholegeo.spinpl -from 0.0 -to $unitL -increment $uincrement -format $precision -width 6 -textvariable pl -font $fontspin -justify right] -column 1 -row [incr irow]

grid [tk::frame  .editholegeo.changesTrou] -rowspan 2 -columnspan 2 -column 3 -row $irow
grid [tk::button .editholegeo.changesTrou.changeTrou -text "Appliquer les changements" -command "modify_hole"] -sticky nwes -column 3 -row 0
grid [tk::button .editholegeo.changesTrou.nochangeTrou -text "Annuler les changements" -command {edit_hole hole_index $hole_index}] -sticky nwes -column 3 -row 1

grid [tk::label  .editholegeo.labeltroupd0 -text "Diamtre Extrieur :"] -column 2 -row $irow -sticky s
grid [tk::spinbox .editholegeo.spinpd0 -from 0.0 -to $unitL -increment $uincrement -format $precision -width 6 -textvariable pd0 -font $fontspin -justify right] -column 2 -row [incr irow]

# Si trou existant, pas de cl ou cl ?
grid [tk::checkbutton .editholegeo.cleoupas -text "Couvert d'une cl" -variable chkCle -command "update_key"] -column 2 -row [incr irow]
# Si cl,  plateau plein ou creux ?
grid [tk::radiobutton .editholegeo.plateauplein -text " plateau plein" -variable chkPlein -value 2 -command "maj_plateaucle"] -column 3 -columnspan 2 -row $irow -sticky w
grid [tk::radiobutton .editholegeo.plateaucreux -text " plateau creux" -variable chkPlein -value 1 -command "maj_plateaucle"] -column 3 -columnspan 2 -row [incr irow] -sticky w
set chkPlein 2

grid [tk::label  .editholegeo.labeltroucl -text "Leve, Dist. trou - cl :"] -column 1 -row $irow -sticky s
grid [tk::spinbox .editholegeo.spinplcl -from 0.0 -to $unitL -increment $uincrement -format $precision -width 6 -textvariable plevee -font $fontspin -justify right] -column 1 -row [incr irow]

grid [tk::frame .editholegeo.dessincle -background black] -column 2 -row [incr irow] -sticky s
grid [tk::label .editholegeo.dessincle.labelcledessin -text "      " -background black] -column 0 -row 0 -padx 10 -pady 2

grid [tk::button .editholegeo.help -text "?" -command "open_help_window {holes}"]  -column 0 -row 4

.editholegeo.supprTrou configure -command "
set pdf 0
set pl 0
set pd0 0"

wm withdraw .editholegeo
# Fin de la construction de l'interface d'dition de trou
#*******************
proc maj_plateaucle {} {
  global chkPlein
  .editholegeo.dessincle.labelcledessin configure -background [lindex {red white black} $chkPlein]
}

proc update_key {} {
  global chkCle
  variable contenant .editholegeo
  variable lesitems { plateauplein plateaucreux labeltroucl spinplcl dessincle }
  if {$chkCle>0} {
    foreach contenu $lesitems {
    grid $contenant.$contenu
    maj_plateaucle
    }
  } else { 
    foreach contenu $lesitems {
      grid remove $contenant.$contenu 
    }
  }
}

# Procdure appliquant des modifications  un trou existant ou non, ou le supprimant
# Le trou modif est celui en cours d'dition, les nouveaux paramtres sont rcuprs de l'interface d'dition de trou
# Apply change to current hole (existing or not), or suppressing it (if parameters set to 0)
# The currently under edition hole is affected, the numerical values are taken from the editholegeo interface
proc modify_hole {} {
  
  foreach ilist {L unitL D0P DLP LP ISTYLE LEVEE 
  chkCle chkPlein
  pd0 pdf pl plevee
  hole_index id_Hole} {
    global "$ilist"
  }
  # Fermer l'edition de doigtes pour modifier le trou
  if {[winfo exists .visu_edit_fingering]} {
      eval [wm protocol .visu_edit_fingering WM_DELETE_WINDOW]
  }
  
  lset D0P $hole_index [format %G [expr {1.0*$pd0/$unitL}]]
  lset DLP $hole_index [format %G [expr {1.0*$pdf/$unitL}]]
  lset LP  $hole_index [format %G [expr {1.0*$pl/$unitL}]]
  lset ISTYLE $hole_index [format %G [expr {$chkCle*$chkPlein}]]
  lset LEVEE $hole_index [format %G [expr {1.0*$plevee/$unitL}]]
  
  global xzoom
  global ximageoffset 50
  
  set ifor $hole_index
  
  set Linstrument [::tcl::mathop::+ {*}[lrange $L [expr {1+$ifor}] end]]
  set xcumul [expr {$ximageoffset+$xzoom*$Linstrument}]
  
  set tmpP [lindex $D0P $ifor]
  geofingeringchanged
  retrace
# Une fois le trou (re)dessin, on met  jour l'interface d'dition de trou
  edit_hole hole_index $hole_index
}

proc end_edit_hole {} {
# Dummy proc, can be replaced by a real one by a macro, 
# see at the bottom of this source file "Run macro if asked"
}

#***********************************************************************************************
# Mise  jour des champs de l'interface d'dition de trou lorsqu'un nouveau trou est slectionn
# Update all editholegeo fields from the selected hole number
proc edit_hole {hole_indexvar hole_index_value} {
  upvar 1 $hole_indexvar hole_index

  foreach ilist {L D0P DLP LP ISTYLE LEVEE chkCle chkPlein hole_indexP1
  IFLUTE
  leftcolor rightcolor
  pd0 pdf pl plevee
  id_Area_Section id_Area_SectionHole id_Area_HoleSection id_Hole
  section_index
  wgeo_et wgeo_eh
  activecolor} {
    global "$ilist"
  }
  if {$hole_indexP1>=[llength $D0P]} {
    if {[string match {normal} [wm state .editholegeo]]} {
      wm withdraw .editholegeo
    }
    return
  }
  
  
  .maincanvas itemconfigure HO[lindex $id_Hole $hole_index] -outline black -width [expr {1+([lindex $ISTYLE $hole_index]>0)*2}] -dash {}
  
  if {[string match {normal} [wm state .editholegeo]]} {
    set wgeo_eh "[wm geometry .editholegeo]"
  }
  if {[string match {normal} [wm state .editsectiongeo]]} {
    set wgeo_et "[wm geometry .editsectiongeo]"
  }
  wm withdraw .editsectiongeo
  .editholegeo.numerotrou.combotrou configure -values [lsearch -all -not -start 1 "[lrange $L 0 end-1] 0" "NaN" ]
  #wm deiconify .editholegeo 
  if {$hole_index_value>[expr {[llength $L]-2}]} {
    set hole_index_value [expr {[llength $L]-2}]
  }
  if {$hole_index_value<0} {
    set hole_index_value 0
    set hole_index_value 0
  }
  set iTm1 [expr {$section_index-1}]
  if {$iTm1>-1} {
    .maincanvas itemconfigure [lindex $id_Area_Section $iTm1] -fill lightgrey
  }
  set iTm1 [expr {$section_index+1}]
  if {$iTm1<[llength $L]} {
    .maincanvas itemconfigure [lindex $id_Area_Section $iTm1] -fill lightgrey
  }
  set iTm1 [expr {$hole_index+1}]
  foreach ifor "
    [lindex $id_Area_Section $section_index]
    [lindex $id_Area_HoleSection $hole_index]
    [lindex $id_Area_SectionHole $hole_index] 
    [lindex $id_Area_SectionHole $iTm1]
    [lindex $id_Area_HoleSection $iTm1]" {
  .maincanvas itemconfigure $ifor -fill lightgrey
  }
  
  set hole_index $hole_index_value
  set hole_indexP1 $hole_index
  incr hole_indexP1

  .maincanvas itemconfigure [lindex $id_Area_HoleSection $hole_index] -fill $rightcolor
  .maincanvas itemconfigure [lindex $id_Area_SectionHole $hole_index] -fill $rightcolor
  set iTm1 [expr {$hole_index+1}]
  .maincanvas itemconfigure [lindex $id_Area_SectionHole $iTm1] -fill $leftcolor
  .maincanvas itemconfigure [lindex $id_Area_HoleSection $iTm1] -fill $leftcolor
  
  foreach iTm1 [winfo children .editholegeo.frameiflute] {
   destroy $iTm1
  }

  set iTm1 [expr {$hole_index-1}]
  .editholegeo.troncdt  configure -text "Tronon \nN$hole_indexP1"
  .editholegeo.trousuiv configure -text "Editer \nTrou n$hole_index"
  if {$iTm1<0} {
    .editholegeo.trousuiv configure -text "Extrmit\nTronon n0"
  }
  
  set iTm1 [expr {$hole_index+1}]
  set hole_index_value $hole_indexP1
  incr hole_index_value
  .editholegeo.troncgt  configure -text "Tronon \nN$hole_index_value"
  .editholegeo.trouprec configure -text "Editer \nTrou n$hole_index_value"
  if {$iTm1>[expr {[llength $DLP]-2}]} {
    .editholegeo.trouprec configure -text "Extrmit\nTronon n$hole_index_value"
    grid [tk::label .editholegeo.frameiflute.iflutetext -text "IFLUTE = "] -column 0 -row 0
    grid [tk::label .editholegeo.frameiflute.ifluteval -textvariable IFLUTE] -column 1 -row 0 -sticky w
    #grid [tk::label .editholegeo.frameiflute.ifluteexp -text "0 : flte  bec\n\n-1 : flte \ntraversire\n\n1 : anche solide\n\n2 : cuivre" -justify left] -column 0 -row 2 -pady 5 -columnspan 2
    grid [tk::frame .editholegeo.frameiflute.ifluteexp] -column 0 -row 2 -pady 5 -columnspan 2
    variable ifltxt
    variable nifltxt
    set nifltxt -1
    foreach ifltxt {
      {0 " : flte  bec"}
      {-1 " : flte traversire"}
      {1 " : anche solide"}
      {2 " : cuivre"}
    } {
      grid [tk::label .editholegeo.frameiflute.ifluteexp.left[expr {1+[lindex $ifltxt 0]}] -text "[lindex $ifltxt 0]"] -column 0 -row [incr nifltxt] -sticky e
      grid [tk::label .editholegeo.frameiflute.ifluteexp.right[expr {1+[lindex $ifltxt 0]}] -text "[lindex $ifltxt 1]"] -column 1 -row $nifltxt -sticky w
    }
    foreach ifltxt {right left} {
    .editholegeo.frameiflute.ifluteexp.$ifltxt[expr {$IFLUTE+1}] configure -background white
    }
  }

  set pd0 [printmm $D0P $hole_index]
  set pdf [printmm $DLP $hole_index]
  set pl  [printmm $LP $hole_index]
  # Par dfaut, pas de cl, et si cration de cl, par dfaut plateau plein
  set chkCle 0
  set chkPlein 2
  if {[expr {[lindex $ISTYLE $hole_index]+1}]>1} {
    # Si cl existante, case coche et type de plateau mis  jour
    set chkCle 1
    set chkPlein [lindex $ISTYLE $hole_index]    
  }
  set plevee  [printmm $LEVEE $hole_index]
  update_key
  if {$pd0>0} {
    .maincanvas itemconfigure HO[lindex $id_Hole $hole_index] -outline $activecolor -width 5 -dash 8
  }
  wm deiconify .editholegeo
  wm geometry .editholegeo [regsub {(x[0-9]*)[^0-9].*} $wgeo_eh {\1}]
  wm geometry .editholegeo ""
  
  # Call macro customizable proc, default = dummy proc
  end_edit_hole
}
# Fin de la mise  jour des champs de l'interface d'dition de trou lorsqu'un nouveau trou est slectionn
#*********************************************************************************************************

#***********************************************
# Reprsentation graphique des tronons et trous
# Graphical representation of sections and holes

proc draw_main_view {} {
  #Initialise les listes d'objets graphiques lignes
  foreach ifor {id_Interface id_Contour_Section 
    id_Area_Section id_Area_HoleSection id_Area_SectionHole 
    id_Hole id_Key
    refdoigte_notes} {
    global $ifor
    set $ifor [list]
  }
  foreach ifor {L D0 DL
    LP D0P DLP
    LEVEE ISTYLE
    doigtes_notes
    id_EndOpen
    xzoom yzoom ximageoffset
    Linstrument
    Instrument_Screen_Width
    Height_Main_Section_Visu h_gap_graphs
    graphique0trou graphiqueFtrou graphique0ortho graphiqueFortho
    hole_index hole_indexP1 section_index
    fingering_size
    activecolor} {
    global $ifor
  }
  
  # Clean up future obsolete windows
  .maincanvas delete all
  foreach ifor {.visu_edit_fingering .visu_flaedit .visu_impedance .visu_accuracy .visu .calclog} {
    if {[winfo exists $ifor]} {
        eval [wm protocol $ifor WM_DELETE_WINDOW]
	wm geometry $ifor ""
    }
  }
    foreach ifor {.visu_edit_fingering} {
    if {[winfo exists $ifor]} {
        destroy $ifor
    }
  }
  
  set section_index 1
  set id_pressure -1

  .maincanvas create text [expr {$Instrument_Screen_Width/2}] [expr {$graphique0ortho-10}] -text "Intrieur de la perce"
  .maincanvas create text [expr {$Instrument_Screen_Width/2}] [expr {$graphiqueFtrou+$h_gap_graphs-10}] -text "Extrieur de l'instrument"

  # Maximum size for L (cumulative Length) and D (frustum Diameter) :
  set Linstrument [::tcl::mathop::+ {*}$L]
  
  set id_EndOpen 0
  
  set xzoom [expr {1.0*$Instrument_Screen_Width/$Linstrument}]
  set yzoom $xzoom
  variable pzmax 0
  variable tmppz 0
  variable pzmax1
  variable pzmax2
  variable pzmaxc
  foreach pzmax1 $LP pzmax2 $LEVEE pzmaxc $ISTYLE {
    if {$pzmaxc>0} {
      set pzmaxc 1
    }
    set tmppz [expr {$pzmax1+$pzmaxc*$pzmax2}]
    if {$tmppz>$pzmax} {
      set pzmax $tmppz
    }
  }
  set pzoom [expr {($graphiqueFtrou-$graphique0trou-10-5)/(0.0001+$pzmax)}]
  set ifor 0
  set xline [lindex $L 0]
  set xcumul [expr {$ximageoffset+$xzoom*$Linstrument}]
  set xold $xcumul
  variable oldidAT ""
  

  set xtmp [expr {$ximageoffset+$Instrument_Screen_Width+1}]
  set tmpDL [expr {$Height_Main_Section_Visu-$yzoom*[lindex $DL 0]}]
  set id_EndOpen [.maincanvas create rectangle $xtmp $Height_Main_Section_Visu [expr {$xtmp+$ximageoffset/4}] $tmpDL]
  set EndOpenText "{\"Ouverte\" \"Ferme\"}"
  .maincanvas itemconfigure $id_EndOpen -activeoutline $activecolor -activewidth 3 -outline lightgrey
  .maincanvas bind $id_EndOpen <Enter> "
  .status_bar configure -text  \"Extrmit de l'instument : \[lindex  $EndOpenText \$C1\]\"
  handcursor .maincanvas"
  .maincanvas bind $id_EndOpen <Leave> "set old_cursor {}
  defaultcursor .maincanvas"
  .maincanvas bind $id_EndOpen <1> "
  set C1 \[expr {1-\$C1}\]
  geofingeringchanged
  .status_bar configure -text  \"Extrmit de l'instrument : \[lindex  $EndOpenText \$C1\]\"
  retrace"
  
  # Pour chaque tronon : dessin d'un rectangle pour marquer la largeur et d'un segment reliant les bords gauche et droit pour marquer les diamtres
  # Draw the complete intrument, sliced in a plane including the revolution axis (half view)
  # For each conical frustum, draw the part of the sliced frustum above the revolution axis : 
  # draw a rectangle, 
  # the left and right segments of which figuring the parallel cutting planes of the frustum
  # the distance bewtween those segments figuring the length,
  # and an additionnal segment linking the upper left corner and upper right corner of the sliced frustum 
  # to figure the left and right diameters
  
  foreach xline $L {
    set tmpD0 [expr {$Height_Main_Section_Visu-$yzoom*[lindex $D0 $ifor]}]
    set tmpDL [expr {$Height_Main_Section_Visu-$yzoom*[lindex $DL $ifor]}]
    
    set xtmp  [expr {$xzoom*$xline}]
    set xcumul [expr {$xcumul-$xtmp}]
  
  # Rectangles tronons
  # Frusta rectangles
    lappend id_Area_Section [.maincanvas create rectangle $xold 0 $xcumul $Height_Main_Section_Visu -activewidth 3 -fill lightgrey -dash 3]
    variable txtifor "\[lsearch -exact \$id_Area_Section [lindex $id_Area_Section $ifor]\]"
    .maincanvas bind [lindex $id_Area_Section $ifor] <1> "
    focus .
    edit_section section_index \"$txtifor\"
    raise .editsectiongeo
    focus .editsectiongeo"
    .maincanvas bind [lindex $id_Area_Section $ifor] <Enter> "variable tifor $txtifor
    .status_bar configure -text  \"Tronon \[expr {1+\$tifor}] :   Longueur  \[format %%G \[expr {\$unitL*\[lindex \$L \$tifor\]}\]\]   Diamtre initial \[format %%G \[expr {\$unitL*\[lindex \$D0 \$tifor\]}\]\]   Diamtre final \[format %%G \[expr {\$unitL*\[lindex \$DL \$tifor\]}\]\]\"
    handcursor .maincanvas"
    .maincanvas bind [lindex $id_Area_Section $ifor] <Leave> "set old_cursor {}
    defaultcursor .maincanvas"
    # Dessin du contour selon les diamtres de chaque tronons
    # Frusta diameters : linking segments
    lappend id_Contour_Section [.maincanvas create line $xold $tmpDL $xcumul $tmpD0 -activewidth 3 ]
    .maincanvas bind [lindex $id_Contour_Section $ifor] <1> "
    focus .
    edit_section section_index \"$txtifor\"
    raise .editsectiongeo
    focus .editsectiongeo"
    #variable txtifor "\[lsearch -exact \$id_Contour_Section [lindex $id_Contour_Section $ifor]\]"
    #.maincanvas bind [lindex $id_Contour_Section $ifor] <Enter> ".status_bar configure -text \"generatrice $txtifor\""
  
  # Trous
  # Holes
      set with_key 0
      set key_fill ""
      if {[lindex $ISTYLE $ifor]>0} {
        set with_key 10
        if {[lindex $ISTYLE $ifor]>1} {
        set key_fill black
        }
      }
    set tmpP [lindex $D0P $ifor]
    if {$tmpP>0} {
      set tmpxhg [expr {$xcumul-$xzoom*$tmpP/2}]
      set tmpxhd [expr {$xcumul+$xzoom*$tmpP/2}]
      set tmpP  [lindex $DLP $ifor]
      set tmpxg [expr {$xcumul-$xzoom*$tmpP/2}]
      set tmpxd [expr {$xcumul+$xzoom*$tmpP/2}]
      set tmpP  [lindex $LP $ifor]
      set tmph  [expr {$graphique0trou+$pzoom*$tmpP}]
      set tmplKey [expr {$tmph+$pzoom*[lindex $LEVEE $ifor]}]
      set tmphKey [expr {$tmplKey+$with_key}]
      lappend id_Hole [.maincanvas create polygon $tmpxg $graphique0trou $tmpxhg "$tmph" $tmpxhd "$tmph" $tmpxd $graphique0trou -outline black -activewidth 3 -fill white]
      lappend id_Key [.maincanvas create polygon $tmpxhg $tmplKey $tmpxhg "$tmphKey" $tmpxhd "$tmphKey" $tmpxhd $tmplKey -outline black -fill $key_fill]
      
    } else {
      lappend id_Hole [.maincanvas create polygon $xcumul $graphique0trou $xcumul $graphique0trou $xcumul $graphique0trou $xcumul $graphique0trou -outline black -activewidth 3 -fill white]
      lappend id_Key [.maincanvas create polygon $xcumul $graphique0trou $xcumul $graphique0trou $xcumul $graphique0trou $xcumul $graphique0trou -outline black -fill $key_fill]
    }
    .maincanvas addtag H[lindex $id_Hole $ifor] withtag "[lindex $id_Hole $ifor]"
    .maincanvas addtag H[lindex $id_Hole $ifor] withtag "[lindex $id_Key $ifor]"
    .maincanvas itemconfigure  [lindex $id_Key $ifor] -state [lindex {hidden normal} [lindex $ISTYLE $ifor]]
    
  # Interfaces entre tronons pour centrer les trous
    lappend id_Interface [.maincanvas create line $xcumul $graphique0ortho $xcumul $graphiqueFtrou -activewidth 3  -dash 3 -tags H[lindex $id_Hole $ifor]]
  
  # Aires de part et d'autres des interfaces pour diter les trous
    variable xdemi [expr {0.5*($xold+ $xcumul)}]
    lappend id_Area_SectionHole [.maincanvas create rectangle $xdemi $graphique0trou $xold   $graphiqueFtrou -fill lightgrey      -width 0 -tags "T[lindex $id_Area_Section $ifor] H$oldidAT"]
    lappend id_Area_HoleSection [.maincanvas create rectangle $xdemi $graphique0trou $xcumul $graphiqueFtrou -fill lightgrey -width 0 -tags "T[lindex $id_Area_Section $ifor] H[lindex $id_Hole $ifor]"]
    .maincanvas lower "T[lindex $id_Area_Section $ifor]"
    #if {$ifor>0} {
    #variable txtifor "\[lsearch -exact \$id_Hole \[lindex \$id_Hole [expr ($ifor-1)]\]\]"
    #.maincanvas bind [lindex $id_Area_SectionHole $ifor] <Enter> "variable tifor $txtifor
    #.status_bar configure -text \"Trou \$tifor :   Hauteur \[format %%G \[expr \$unitL*\[lindex \$LP \$tifor\]\]\]   Diamtre Extrieur \[format %%G \[expr \$unitL*\[lindex \$D0P \$tifor\]\]\]   Diamtre Intrieur \[format %%G \[expr \$unitL*\[lindex \$DLP \$tifor\]\]\]\""
    #}
  
    variable txtifor "\[lsearch -exact \$id_Hole [lindex $id_Hole $ifor]\]"
    if {$ifor<[llength $LP]} {
      .maincanvas bind "H[lindex $id_Hole $ifor]" <1> "
      focus .
      edit_hole hole_index \"$txtifor\"
      raise .editholegeo
      focus .editholegeo"
      .maincanvas bind "H[lindex $id_Hole $ifor]" <Enter> "variable tifor $txtifor
      .status_bar configure -text \"Trou \[expr {1+\$tifor}] :   Hauteur chemine \[format %%G \[expr {\$unitL*\[lindex \$LP \$tifor\]}\]\]   Diamtre Extrieur \[format %%G \[expr {\$unitL*\[lindex \$D0P \$tifor\]}\]\]   Diamtre Intrieur \[format %%G \[expr {\$unitL*\[lindex \$DLP \$tifor\]}\]\]\"
      handcursor .maincanvas"
      .maincanvas bind "H[lindex $id_Hole $ifor]" <Leave> "
      set old_cursor {}
      defaultcursor .maincanvas"
    }
     
    set xold $xcumul
    set oldidAT [lindex $id_Hole $ifor]
    incr ifor
  }
  
  # Cration du rfrencement de doigt li aux identifiants uniques des 
  # objets graphiques trous :
  # Un nouveau trou signifie que ce trou sera bouch par dfaut dans les doigts.
  # La suppression d'un trou bouch dans tous les doigts ne modifie pas le
  # rfrencement des trous en interne, seulement la vision graphique.
  # La suppression d'un trou (0 0 0) rsultant de la fusion de deux tronons
  # se traduit par un identifiant trou non valide dans les doigts,
  # on peut ds lors supprimer les rfrences correspondantes 
  # dans la table ref des doigts ou dtecter ces trous perdus et les ignorer 
  # lors de l'ouverture de la fentre de doigts.
  # Un trou (0 0 0) est toujours rfrenc, si diffrents doigts 
  # le traitent diffremment, ces distinctions seront visibles si le trou passe
  #  une taille non nulle qui le "dmasquerait" de l'dition de doigt
  #set refdoigte_notes [list]
  foreach tmpdoigt $doigtes_notes {
    variable lfingering [list]
    set ifor 0
    foreach iT $id_Hole {
      if {[lindex $tmpdoigt $ifor]<1} {
        lappend lfingering $iT
      }
      incr ifor
    }
    lappend refdoigte_notes $lfingering
  }
  set hole_index 0
  set hole_indexP1 $hole_index
  incr hole_indexP1
  retrace
  edit_section section_index 0

  set fingering_size 440
}

# Met  jour toutes les coordonnes des objets graphiques existants
# Updates every coordinate of every graphical object of the main window
proc retrace {} {
  variable indice
  foreach ilist {D0 DL L D0P DLP LP ISTYLE LEVEE 	leftcolor rightcolor 	curd0 curdl curl	pd0 pdf pl C1 id_EndOpen
  id_Area_Section id_Contour_Section section_index id_Interface id_Area_SectionHole id_Area_HoleSection
  id_Hole hole_index id_Key with_key 	graphique0trou graphiqueFtrou graphiqueFortho graphique0ortho
  xzoom yzoom yorthoc Height_Main_Section_Visu
  ximageoffset Instrument_Screen_Width Linstrument} {
    global "$ilist"
  }
  
  set yzoom [expr {($Height_Main_Section_Visu-5)/(0.0001+[lindex [lsort -real "$D0 $DL"] end])}]
  # Recalcule la largeur instrument
  # Recomputes the total length of the instrument
  set Linstrument [::tcl::mathop::+ {*}$L]
  # Dfinit le zoom pour que l'instrument occupe toute la largeur souhaite
  # Define zoom so that the instrument fits the whished window width
  set xzoom [expr {1.0*$Instrument_Screen_Width/$Linstrument}]
  set xcumul [expr {$ximageoffset+$xzoom*$Linstrument}]
  set xold $xcumul
  
  # Trace middle sketch contours
  global listXYp 
  global listXYm 
  set listXYp {}
  set listXYm {}
  variable oldX 0
  variable newX 0
  variable oldY 0
  set ifor 0
  set oldX $xold
  # 0.5 to get radius from diameter, *1 to double the represented diameter
  set ycczoom [expr {$xzoom*1}]
  set oldY [expr {$ycczoom*[lindex $DL $ifor]}]
  # If end si closed, close the line
  if {$C1>0} {
    lappend listXYp "$oldX" "[expr {$yorthoc-$oldY}]"
  }
  lappend listXYp "$oldX" "[expr {$yorthoc+$oldY}]"
  lappend listXYm "$oldX" "[expr {$yorthoc-$oldY}]"

  for {set ifor 0} {$ifor<[llength $L]} {incr ifor} {
    set newY [expr {$ycczoom*[lindex $DL $ifor]}]
    if {[expr {abs($newY-$oldY)>0}]} {
      lappend listXYp "$oldX" "[expr {$yorthoc+$newY}]"
      lappend listXYm "$oldX" "[expr {$yorthoc-$newY}]"
    }
    set oldX [expr {$xold-$xzoom*[::tcl::mathop::+ {*}[lrange $L 0 $ifor]]}]
    set oldY [expr {$ycczoom*[lindex $D0 $ifor]}]
    lappend listXYp "$oldX" "[expr {$yorthoc+$oldY}]"
    lappend listXYm "$oldX" "[expr {$yorthoc-$oldY}]"
  }
  global contour3p
  global contour3m
  .maincanvas delete $contour3m
  .maincanvas delete $contour3p
  set contour3m [.maincanvas create line {*}$listXYm -width 3 ]
  set contour3p [.maincanvas create line {*}$listXYp -width 3 ]

  set xtmp [expr {$ximageoffset+$Instrument_Screen_Width+1}]
  set tmpDL [expr {$Height_Main_Section_Visu-$yzoom*[lindex $DL 0]}]
  .maincanvas coords $id_EndOpen $xtmp $Height_Main_Section_Visu [expr {$xtmp+$ximageoffset/4}] $tmpDL
  .maincanvas itemconfigure $id_EndOpen -fill [lindex {lightgrey black} $C1]
  
  variable pzmax 0
  variable tmppz 0
  variable pzmax1
  variable pzmax2
  variable pzmaxc
  foreach pzmax1 $LP pzmax2 $LEVEE pzmaxc $ISTYLE {
    if {$pzmaxc>0} {
      set pzmaxc 1
    }
    set tmppz [expr {$pzmax1+$pzmaxc*$pzmax2}]
    if {$tmppz>$pzmax} {
      set pzmax $tmppz
    }
  }
  set pzoom [expr {($graphiqueFtrou-$graphique0trou-10-5)/(0.0001+$pzmax)}]
  
  global holesketch3
  foreach ifor $holesketch3 {
    .maincanvas delete $ifor
  }
  
  variable altery -1
  set tmpxhg [expr {2*$xcumul}]
  
  for {set ifor 0} {$ifor<[llength $L]} {incr ifor} {
    set xline [lindex $L $ifor]
    set Linstrument [::tcl::mathop::+ {*}[lrange $L $ifor end]]
    set tmpD0 [expr {$Height_Main_Section_Visu-$yzoom*[lindex $D0 $ifor]}]
    set tmpDL [expr {$Height_Main_Section_Visu-$yzoom*[lindex $DL $ifor]}]
  
    set xtmp  [expr {$xzoom*$xline}]
    #puts "$tmpD0  $xtmp  $tmpDL"
    set xcumul [expr {$xcumul-$xtmp}]
  
# Rectangles tronons
    .maincanvas coords [lindex $id_Area_Section    $ifor] $xold 0      $xcumul $Height_Main_Section_Visu
    .maincanvas coords [lindex $id_Contour_Section $ifor] $xold $tmpDL $xcumul $tmpD0
    set tmpP [lindex $D0P $ifor]
    
# Trous
    set with_key 0
    set key_fill ""
    if {[lindex $ISTYLE $ifor]>0} {
      set with_key 10
      if {[lindex $ISTYLE $ifor]>1} {
      set key_fill black
      }
    }
    if {$tmpP>0} {
      set tmpxhd [expr {$xcumul+$xzoom*$tmpP/2}]
      if {$tmpxhd>$tmpxhg} {
        # Overlap : offset holes
	.maincanvas coords [lindex $holesketch3 end] $tmpxhg $yorthoc $tmpxhd [expr {$yorthoc+($altery)*$xzoom*$oldtmpP}]
	set altery [expr {-$altery}]
	set tmpxhg [expr {$xcumul-$xzoom*$tmpP/2}]
        lappend holesketch3 [.maincanvas create oval $tmpxhg $yorthoc $tmpxhd [expr {$yorthoc+($altery)*$xzoom*$tmpP}]]
      } else {
        set tmpxhg [expr {$xcumul-$xzoom*$tmpP/2}]
        # XXX Attention, gerer recouvrement trous, et si diametre trou ou troncon hors cadre prevu ( alterxzoom)?
        lappend holesketch3 [.maincanvas create oval $tmpxhg [expr {$yorthoc-$xzoom*$tmpP/2}] $tmpxhd [expr {$yorthoc+$xzoom*$tmpP/2}]]
      }
      if {$with_key>0} {
        .maincanvas itemconfigure [lindex $holesketch3 end] -width 3 -fill lightgrey
	.maincanvas lower [lindex $holesketch3 end]
        if {[lindex $ISTYLE $ifor]>1} {
	  .maincanvas itemconfigure [lindex $holesketch3 end] -fill $key_fill
        }
      }
      .maincanvas addtag H[lindex $id_Hole $ifor] withtag [lindex $holesketch3 end] 
      .maincanvas addtag HO[lindex $id_Hole $ifor] withtag [lindex $holesketch3 end] 
      .maincanvas bind [lindex $holesketch3 end] <Enter> ".maincanvas itemconfigure [lindex $id_Interface $ifor] -width 3
      handcursor .maincanvas"
      .maincanvas bind [lindex $holesketch3 end] <Leave> ".maincanvas itemconfigure [lindex $id_Interface $ifor] -width 1
      set old_cursor {}
      defaultcursor .maincanvas"
      
      set oldtmpP $tmpP
      set tmpP  [lindex $DLP $ifor]
      set tmpxg [expr {$xcumul-$xzoom*$tmpP/2}]
      set tmpxd [expr {$xcumul+$xzoom*$tmpP/2}]
      
      set tmpP  [lindex $LP $ifor]
      set tmph  [expr {$graphique0trou+$pzoom*$tmpP}]
      .maincanvas coords [lindex $id_Hole $ifor]  "$tmpxg  $graphique0trou $tmpxhg $tmph $tmpxhd $tmph $tmpxd $graphique0trou"
      
    
      
    set tmplKey [expr {$tmph+$pzoom*[lindex $LEVEE $ifor]}]
    set tmphKey [expr {$tmplKey+$with_key}]
    .maincanvas coords [lindex $id_Key $ifor] $tmpxhg $tmplKey $tmpxhg "$tmphKey" $tmpxhd "$tmphKey" $tmpxhd $tmplKey
    } else {
      .maincanvas coords [lindex $id_Hole $ifor] $xcumul $graphique0trou $xcumul $graphique0trou $xcumul $graphique0trou $xcumul $graphique0trou
      .maincanvas coords [lindex $id_Key $ifor]  $xcumul $graphique0trou $xcumul $graphique0trou $xcumul $graphique0trou $xcumul $graphique0trou
    }
    .maincanvas itemconfigure  [lindex $id_Key $ifor] -fill $key_fill
    .maincanvas itemconfigure  [lindex $id_Key $ifor] -state [lindex {hidden normal} [lindex $ISTYLE $ifor]]
      #.maincanvas addtag H[lindex $id_Hole $ifor] withtag "[lindex $id_Hole $ifor]"

# Interfaces entre tronons pour centrer les trous
       .maincanvas coords [lindex $id_Interface $ifor] $xcumul $graphiqueFtrou $xcumul $graphique0ortho

# Aires de part et d'autres des interfaces pour diter les trous
# Clickable areas on both sides of frusta interfaces to open hole edition window
  variable xdemi [expr {0.5*($xold+ $xcumul)}]
  .maincanvas coords [lindex $id_Area_SectionHole $ifor] $xdemi $graphique0trou $xold   $graphiqueFtrou
  .maincanvas coords [lindex $id_Area_HoleSection $ifor] $xdemi $graphique0trou $xcumul $graphiqueFtrou
  set xold $xcumul
  }

}

set STIM_ALL {}

# Extract data from main out file
namespace eval mainout_namespace {
proc read_mainout {} {
  global istutt41 istutt42
  set outname "tutt25.out"
  if {$istutt41<1} {
    set outname "tutt42.out"
    if {$istutt42<1} {
      set outname "tutt43.out"
    }
  }
  if { [catch {set mainout_file [open  $outname r] } errormsg ]} {
    puts  "Pb ouverture fichier tutt25.out\n $errormsg"
  } else {
    foreach ilist {NTESSC NTESSB FLA  ITMPNT degres_tessiture_notes doublepi
    computeddegre computednomnote expectedw computedw computedstim nbcomputed computedcent
    semitone 
    accuracy_change pressure_change impedance_change
    launched
    STIM_ALL} {
      global "$ilist"
    }
    foreach ilist {tmpi ligne recordls recordl1 recordl2 recordl3 tmpcomputedcent} {
      variable $ilist
    }
    
    variable results_reached 0
    variable nbcomputed 0
    variable irecord 0
    variable tmpexpectedw 0
    variable tmpcomputedw 0
    variable tmpcomputedstim undefined
    variable tmpcomputeddegre undefined
    variable tmpcomputednomnote undefined
    
    variable dpiFLA [expr {$doublepi*$FLA}]
    set recordls [list ]
    while {[gets $mainout_file ligne] >=0} {
      if {$results_reached<1} {
        if {[regexp {NOTE *JUSTESSE *EMBOUCHURE *EMISSION *PERTES *VOLUME *CRITERE} $ligne]} {
	  set results_reached 1
	  set STIM_ALL {}
	  puts $ligne
	}
      } else {
	puts $ligne
	if {$results_reached>1} {
	  if {$results_reached<3} {
	    if {[regexp {\.\.} $ligne]} {incr results_reached}
	  } else {
	    if {[regexp {\.\.} $ligne]} {
	      if {$irecord>2} {
	        set recordl2 [lindex $recordls [expr {$irecord-2}]] 
		set recordl3 [lindex $recordls [expr {$irecord-1}]] 
	        set tmpexpectedw [lindex $recordl2 0]
		set tmpcomputedw [lindex $recordl2 1]
		set tmpcomputedstim [lindex $recordl2 5]
		set tmpcomputeddegre [format "%.0f" [expr {$semitone*log($tmpexpectedw/$dpiFLA)+$NTESSB+1}]]
		set tmpcomputednomnote ""
		set tmpcomputedcent [lindex $recordl3 0]
		set recordl1 [lindex $recordls [expr {$irecord-3}]]
		if {[llength $recordl1]>6} {set tmpcomputednomnote [lindex $recordl1 0]}
		puts "$tmpcomputeddegre ($tmpcomputednomnote)"
		incr nbcomputed
		lappend STIM_ALL $tmpcomputedstim
	      }
	      set recordls [list ]
	      set irecord 0
	    } else {
	      lappend recordls [regsub {\-NaN} $ligne { -NaN}]
	      incr irecord
	    }
	  }
	} else {
	  if {[regexp { *STIM} $ligne]} {incr results_reached}
	}
      }
    }
    close $mainout_file
    
    puts "STIMS : $STIM_ALL"
    puts "launched : $launched"
    if {[file exists zim.out]>0} {
      if {$nbcomputed<2} {
    	set expectedw $tmpexpectedw
	set computedw $tmpcomputedw
	set computedstim $tmpcomputedstim
	set computeddegre $tmpcomputeddegre
	set computednomnote $tmpcomputednomnote
	set computedcent $tmpcomputedcent
	puts " computedcent c$computedcent"
	puts "$computeddegre ($computednomnote)"
	if {$launched>0} {
	  # Warning ! If NTESSC = 1, Old results can be presented as up to date...
	  if {[file exists justess.out]>0} {
            if {[file mtime zim.out]>[file mtime justess.out]} {
	      set impedance_change ""
	      set pressure_change ""
	    } elseif {$NTESSC<2} {
              set accuracy_change "N"
	    }
	  } else {
	    set impedance_change ""
	    set pressure_change ""
	  }
	}
      } elseif {$launched>0} {
        if {[file exists justess.out]>0} {
          if {[file mtime zim.out]<[file mtime justess.out]} {
	    puts "computed $nbcomputed"
	    puts "ntessc $NTESSC"
	    puts "[string equal $nbcomputed $NTESSC]"
            if {[string equal $nbcomputed $NTESSC]>0} {
	      set accuracy_change "N"
	      puts "accuracy_change $accuracy_change"
	    }
          }
        }
      }
    } else {
      if {[file exists justess.out]>0} {
        if {[string equal $nbcomputed $NTESSC]>0} {
          set accuracy_change "N"
	}
      }
    }
  }
}
}

# Pressure visualization
namespace eval pressure_visu_namespace {

proc color_degree {rank} {
# Mark the holes according to the degree fingering
  foreach ilist {
    activecolor
    id_Hole
    
    refdoigte_notes NTESSC} {
    global "$ilist"
  }
  incr rank -1
  if {$rank<$NTESSC} {
    if {$rank>-1} {
      #Clean up if a hole was in edition mode
      retrace
      foreach iT [lrange $id_Hole 0 end-1] {
        if {[lsearch -exact -integer [lindex $refdoigte_notes $rank] $iT]<0} {
          #  .visu_edit_fingering.right.framefinger$ifinger.fingers itemconfigure H$iT -fill "lightgrey"
          .maincanvas itemconfigure HO$iT -outline $activecolor -width 5 -dash 8
        }
      }
    }
  }
}

proc add_visu_pressure {} {
  if { [catch {set pressure_file [open "press.out" r] } errormsg ]} {
    #error "Pb ouverture fichier press.out\n $errormsg"
    puts  "Pb ouverture fichier press.out\n $errormsg"
  } else {
    foreach ilist {pressure_x pressure_p pressure_pmax pressurezoom pressurexzoom id_pressure 
    Instrument_Screen_Width ximageoffset Height_Main_Section_Visu 
    degres_tessiture_notes noms_notes computeddegre computednomnote NTESSC
    pressure_change} {
      global "$ilist"
    }
    set pressure_x [list ]
    set pressure_p [list ]
    set pressure_pmax 0
    variable i_line_pressure 0
    variable ligne
    while {[gets $pressure_file ligne] >=0} {
      incr i_line_pressure
      lappend pressure_x [lindex $ligne 0]
      lappend pressure_p [lindex $ligne 1]
      if {[lindex $ligne 1]>$pressure_pmax} {
        set pressure_pmax [lindex $ligne 1]
      }
    }
    close $pressure_file
    if {$i_line_pressure>1} {
      set pressurezoom [expr {0.9*$Height_Main_Section_Visu/$pressure_pmax}]
      set pressurexzoom [expr {$Instrument_Screen_Width/[lrange $pressure_x end end]}]
      variable iT 0
      variable allpoints [list ]
      variable ixpressure
      foreach ixpressure $pressure_x {
        variable curpresv
	set curpresv [lindex $pressure_p $iT]
	if {[string is double $curpresv] && $curpresv == $curpresv} {
          lappend allpoints [expr {$ximageoffset+$ixpressure*$pressurexzoom}] 
          lappend allpoints [expr {$Height_Main_Section_Visu-[lindex $pressure_p $iT]*$pressurezoom}]
	}
        incr iT
      }
      .maincanvas delete $id_pressure
      if {[llength $allpoints]<4} {
        return
      }
      set id_pressure [.maincanvas create line {*}$allpoints -fill red -activewidth 3]
      .maincanvas bind $id_pressure <1> "puts {selection pressure}"
      .maincanvas bind $id_pressure <Enter> "
      .status_bar configure -text  \"Pression : Nom note = $computednomnote     Degr = $computeddegre \$pressure_change\""
      set iT 0
      if {[string equal $computeddegre "Undefined"]<1} {
        if {[string equal $computeddegre "undefined"]<1} {
	  # Look for rank corresponding to computed degree and note
	  global computedrank
	  set computedrank -1
	  variable finger
	  puts "Recherche $computednomnote dans\n[regsub -all {'} $noms_notes {}]"
	  foreach finger [lsearch -all [regsub -all {'} $noms_notes {}] *[string trim $computednomnote]*] {
	    # finger seems to match computednomnote, check more precisely
	    #puts "[lindex $noms_notes $finger] a examiner (doigte $finger)"
	    if {[lsearch -exact [string trim [regsub -all {'} [lindex $noms_notes $finger] {}]] [string trim $computednomnote]]>-1 || [string length $computednomnote]==0} {
	      # finger precisely matches computednomnote, check degree
	      #puts "$finger matches name $computednomnote, $computeddegre"
	      #puts "[lindex [lindex $degres_tessiture_notes $finger] 2]"
	      if {[lsearch -exact -integer [lindex [lindex $degres_tessiture_notes $finger] 2] $computeddegre]>-1} {
	        # Increment number of perfect matches
	        incr iT
		set computedrank $finger
		incr computedrank
	      }
	    }
	  }
	  if {$iT>0} {
	    set finger ""
	    if {$iT>1} {
	      puts "Warning ! Several fingerings match computed name and degree ! Highest Rank $computedrank selected"
	      set finger "! Plusieurs doigts correspondent  ce nom et  ce degr!"
	    }
	      # Only one perfect match found
	      .maincanvas bind $id_pressure <Enter> "
              .status_bar configure -text  \"Pression : Nom note = $computednomnote     Degr = $computeddegre \$pressure_change $finger\"
              pressure_visu_namespace::color_degree $computedrank
              "
              .maincanvas bind $id_pressure <Leave> "retrace"
              #if {editholegeo} {
              # if {\$pd0>0} {
              #  .maincanvas itemconfigure HO\[lindex \$id_Hole \$hole_index\] -outline $activecolor -width 5 -dash 8
              #}
              #}
            
          }
	}
      }
    }
  }
} 
}


# Impedance visualization
namespace eval impedance_visu_namespace {

set wgeo_z ""

proc add_visu_impedance {} {
  if { [catch {set impedance_file [open "zim.out" r] } errormsg ]} {
    #error "Pb ouverture fichier zim.out\n $errormsg"
    puts  "Pb ouverture fichier zim.out\n $errormsg"
  } else {
    foreach ilist {rising_z falling_z z_impedance_size Instrument_Screen_Width
    computeddegre computednomnote expectedw computedw computedstim computedcent impedance_change} {
      global "$ilist"
    }
    global zstatus
    set zstatus ""
    variable zheight $z_impedance_size
    variable Largeur_Zimpedance $Instrument_Screen_Width
    set rising_z [list ]
    set falling_z [list ]
    set dris [list ]
    set dfal [list ]
    set rnote 0
    set fnote 0
    variable x_z [list ]
    variable z [list ]
    variable i_line_z 0
    variable ligne
    variable z_max 0
    variable z_min 0
    variable tmpz
    variable zfullscale 0
    variable halfwidthhisto 200
    global last_calc_is_impedance
    if {[winfo exists .visu_impedance]} {
       set impedance_visu_namespace::wgeo_z "[wm geometry .visu_impedance]"
       variable w
       foreach w [winfo children .visu_impedance] {
         destroy $w
       }
    } else {
      toplevel .visu_impedance
      wm protocol .visu_impedance WM_DELETE_WINDOW {
        set impedance_visu_namespace::wgeo_z "[wm geometry .visu_impedance]"
        wm withdraw .visu_impedance
      }
    }
    #bind .visu_impedance <Configure> ""
    wm title .visu_impedance "[lindex {Admittance Impdance} $last_calc_is_impedance] $impedance_change"

    variable irow 0
    grid [tk::frame .visu_impedance.ztextvals] -column 0 -row $irow -sticky ns
    grid [tk::frame .visu_impedance.graphical] -column 1 -row $irow -columnspan 2
    grid [tk::canvas .visu_impedance.graphical.zcanvas -width $Largeur_Zimpedance -height $zheight] -column 1 -row $irow

    grid rowconfigure .visu_impedance 0 -weight 1
    grid rowconfigure .visu_impedance.ztextvals 0 -weight 1
    grid rowconfigure .visu_impedance.graphical.zcanvas 0 -weight 1
    grid columnconfigure .visu_impedance.graphical.zcanvas 0 -weight 1
    grid [tk::scrollbar .visu_impedance.ztextvals.sztxtbar -orient vertical -command {.visu_impedance.ztextvals.ztextwidget yview} ] -column 1 -row $irow -sticky ns
    grid [tk::text .visu_impedance.ztextvals.ztextwidget -width 22 -yscrollcommand {.visu_impedance.ztextvals.sztxtbar set}] -column 0 -row $irow -sticky ns

    grid [ttk::separator .visu_impedance.separ_etat -orient horizontal] -column 0 -columnspan 3 -row [incr irow] -sticky nwes
    grid [tk::label .visu_impedance.status_bar -text "barre d'etat"] -sticky ws -column 0 -columnspan 2 -row [incr irow]
    
    grid [tk::button .visu_impedance.help -text "?" -command "open_help_window {impedance}"]    -sticky e -column 2 -row $irow -rowspan 2
    
    grid [tk::frame .visu_impedance.status_bar2] -sticky ws -column 0 -columnspan 2 -row [incr irow]
    grid [tk::canvas .visu_impedance.status_bar2.histo -height 11 -width [expr {2*$halfwidthhisto}] -background white] -column 0 -row 0
     .visu_impedance.status_bar2.histo create rectangle 0 3 [expr {2*$halfwidthhisto}] 9 -width 0 -fill grey
    grid [tk::label .visu_impedance.status_bar2.wfactor -textvariable zstatus] -sticky ws -column 2 -row 0
    
    wm geometry .visu_impedance ""
    update idletasks
    #bind .visu_impedance.graphical <Configure> "
    #  wm geometry .visu_impedance \"\"
    #  wm geometry .visu_impedance \[regsub {^\[^x\]*x\[^0-9\]*(\[^0-9\])} \$impedance_visu_namespace::wgeo_z {\1}\]
    #  wm geometry .visu_impedance \"\"
    #  puts \[wm geometry .visu_impedance\]
    #  puts \"Ici bind histo conf\" "
    #bind .visu_impedance <Configure> "puts \"ici configure\""
    #bind .visu_impedance.ztextvals <Configure> "puts \"ici configure scroll\""
    variable tmpid
    variable tmpid2
    variable lastx 0
    variable lastz 0
    variable curx 0
      
    while {[gets $impedance_file ligne] >=0} {
      incr i_line_z
      set tmpz [lindex $ligne 1]
      if {[string is double $tmpz] && $tmpz == $tmpz} {
      lappend z $tmpz
      if {$tmpz>$z_max} {
        set z_max $tmpz
      }
      if {$tmpz<$z_min} {
        set z_min $tmpz
      }
      
      # Did we cross the z=0 line ?
      if {[expr {$lastz*$tmpz}]<=0} {
        # Only if previous point is not init point
        if {$lastx>0} {
	  # Interpolate the crossing x value (linear interpolation)
	  set curx [lindex $ligne 0]
	  # set curx the x value at which y=0 is crossed :
	  set curx [expr {$lastx+($curx-$lastx)*(0-$lastz)/($tmpz-$lastz)}]
	  set dcurz [expr {1000000*($tmpz-$lastz)/(($curx*$curx-$lastx))}]
	  # Crossing y=0 rising or falling ?
	  if {$tmpz>$lastz} {
	    # Rising
	    lappend rising_z $curx
	    lappend dris $dcurz
	    if {[expr {abs($curx-$computedw)}]<[expr {abs([lindex $rising_z $rnote]-$computedw)}]} {
	      set rnote [llength $rising_z]
	      incr rnote -1
	    }
	  } else {
	    # Falling
	    lappend falling_z $curx
	    lappend dfal $dcurz
	    if {[expr {abs($curx-$computedw)}]<[expr {abs([lindex $falling_z $fnote]-$computedw)}]} {
	      set fnote [llength $falling_z]
	      incr fnote -1
	    }
	  }
	}
      }
      set lastx [lindex $ligne 0]
      lappend x_z $lastx
      set lastz $tmpz
      # Print the current line in the text edition widget
      .visu_impedance.ztextvals.ztextwidget insert $i_line_z.0 "[format {%g} [lindex $ligne 0]]\t[format {%10.0f} $tmpz]\n"
      } else {
      .visu_impedance.ztextvals.ztextwidget insert $i_line_z.0 "[format {%g} [lindex $ligne 0]]\t$tmpz\n"
      }
    }
    close $impedance_file
    wm deiconify .visu_impedance
    raise .visu_impedance
    focus .visu_impedance
    if {$i_line_z<1} {
      puts "Empty file zim.out"
      destroy  .visu_impedance
    } else {
       .visu_impedance.status_bar configure -text  "Nom note = [string trim $computednomnote]     Degr = $computeddegre   Pulsation attendue : $expectedw   Pulsation calcule : $computedw    Harmonicit calcule (STIM) : $computedstim"
      if {$z_max>$z_min} {
        if {[expr {[llength $rising_z]*[llength $falling_z]}]>0} {
	if {[expr {abs([lindex $rising_z $rnote]-$computedw)}]<[expr {abs([lindex $falling_z $fnote]-$computedw)}]} {
	  set fnote -1
	} else {
	  set rnote -1
	}
	}
        variable x0 [lindex $x_z 0]
        variable zfullscale [expr {($zheight-50)/($z_max-$z_min)}]
	variable xfullscale [expr {$Largeur_Zimpedance/([lindex $x_z end]-$x0)}]
        .visu_impedance.graphical.zcanvas create line 0 [expr {$zfullscale*$z_max}] $Largeur_Zimpedance [expr {$zfullscale*$z_max}]
	variable inote 0
	foreach curx $rising_z  {
	  set dcurz [lindex $dris $inote]
	  if {$rnote==$inote} {
	    set tmpid [.visu_impedance.graphical.zcanvas create line [::exprall "{($curx-$x0)*$xfullscale} {0} {($curx-$x0)*$xfullscale} {$zheight-50}"] -fill red -activewidth 3]
	    set tmpid2 $tmpid
	  } else {
	    set tmpid2 [.visu_impedance.graphical.zcanvas create line [::exprall "{($curx-$x0)*$xfullscale} {0} {($curx-$x0)*$xfullscale} {$zheight-50}"] -fill red -activewidth 3 -dash _]
	  }
	  if {$last_calc_is_impedance>0} {
	    .visu_impedance.graphical.zcanvas bind $tmpid2 <Enter> "set zstatus \"[format %.2f $curx] ~ [format %.2f [expr {$curx/$computedw}]] * $computedw     dIm(z)/(w.dw)~ [format %.2f $dcurz]e-6\""
	  } else {
	    .visu_impedance.graphical.zcanvas bind $tmpid2 <Enter> "set zstatus \"[format %.2f $curx] ~ [format %.2f [expr {$curx/$computedw}]] * $computedw\""
	   }
	  incr inote
	  .visu_impedance.graphical.zcanvas create  text [expr {($curx-$x0)*$xfullscale}] [expr {$zheight-30}] -text [format %.2f $curx]
	}
	set inote 0
	foreach curx $falling_z  {
          set dcurz [lindex $dfal $inote]
	  if {$fnote==$inote} {
	    set tmpid [.visu_impedance.graphical.zcanvas create line [::exprall "{($curx-$x0)*$xfullscale} {0} {($curx-$x0)*$xfullscale} {$zheight-50}"] -fill red -activewidth 3]
	    set tmpid2 $tmpid
	  } else {
	    set tmpid2 [.visu_impedance.graphical.zcanvas create line [::exprall "{($curx-$x0)*$xfullscale} {0} {($curx-$x0)*$xfullscale} {$zheight-50}"] -fill red -activewidth 3 -dash _]
	  }
	  if {$last_calc_is_impedance>0} {
	    .visu_impedance.graphical.zcanvas bind $tmpid2 <Enter> "set zstatus \"[format %.2f $curx] ~ [format %.2f [expr {$curx/$computedw}]] * $computedw     dIm(z)/(w.dw)~ [format %.2f $dcurz]e-6\""
	  } else {
	    .visu_impedance.graphical.zcanvas bind $tmpid2 <Enter> "set zstatus \"[format %.2f $curx] ~ [format %.2f [expr {$curx/$computedw}]] * $computedw\""
	   }
	  
	  incr inote
	  .visu_impedance.graphical.zcanvas create  text [expr {($curx-$x0)*$xfullscale}] [expr {$zheight-10}] -text [format %.2f $curx]
	}
	
	variable allpoints [list ]
	variable iT 0
	foreach tmpx $x_z {
	  lappend allpoints [expr {($tmpx-$x0)*$xfullscale}] 
	  lappend allpoints [expr {($z_max-[lindex $z $iT])*$zfullscale}]
	  incr iT
	}
	
      if {[string match -nocase "Undefined" $expectedw]} {
        destroy .visu_impedance.status_bar2.histo
      } else {
          grid [tk::label .visu_impedance.status_bar2.centfactor -text "(justesse $computedcent cents)      "] -sticky ws -column 1 -row 0
        .visu_impedance.status_bar2.histo create rectangle $halfwidthhisto 3 [expr {((100+$computedcent)*$halfwidthhisto/100)}] 9 -fill red
      }
	
	set id_impedance [.visu_impedance.graphical.zcanvas create line {*}$allpoints -fill blue -activewidth 3]
      .visu_impedance.graphical.zcanvas bind $id_impedance <1> "puts {selection impedance}"
      
      }
      #if {[llength $impedance_visu_namespace::wgeo_z]>0} {
      #tk_messageBox -icon warning -title "Impedance taille renormalisee" -message "$impedance_visu_namespace::wgeo_z"
      #puts "geo_z : $impedance_visu_namespace::wgeo_z"
      #update
      #wm geometry .visu_impedance ""
      wm geometry .visu_impedance [regsub {^[^x]*x[0-9]*([^0-9])} $impedance_visu_namespace::wgeo_z {\1}]
      wm geometry .visu_impedance ""
      puts "geoz [wm geometry .visu_impedance]"
      #bind .visu_impedance <Configure> "
      #wm geometry .visu_impedance [regsub {^[^x]*x[0-9]*([^0-9])} $impedance_visu_namespace::wgeo_z {\1}]
      #wm geometry .visu_impedance \"\""
      #puts "ou"
      #}
    }
  }
} 
}

proc accuracy_dualscroll {mini maxi} {
   #.visu_accuracy.jtextvals.sjtxtbar set $mini $maxi
  # .visu_accuracy.graphical.sjgtxtbar set $mini $maxi
   .visu_accuracy.sjgtxtbar set $mini $maxi
  foreach swidget {.visu_accuracy.jtextvals.jtextwidget .visu_accuracy.graphical.jgtextwidget} {
    $swidget yview moveto $mini
  } 
}

proc accuracy_dualview {args} {
  #puts "{*}$args"
  foreach swidget {.visu_accuracy.jtextvals.jtextwidget .visu_accuracy.graphical.jgtextwidget} {
    $swidget yview {*}$args
  }
}


set are_triangle_visible 0
set are_ecartjustline_visible 1

# justesse visualization
namespace eval accuracy_visu_namespace {

toplevel .visu_accuracy
wm geometry .visu_accuracy ""
wm withdraw .visu_accuracy
wm protocol .visu_accuracy WM_DELETE_WINDOW {
  set accuracy_visu_namespace::wgeo_just "[wm geometry .visu_accuracy]"
  wm withdraw .visu_accuracy
}

set wgeo_just ""

proc add_visu_accuracy {} {
  variable is_pitch_ok
  variable cur_lib
  variable abs_lib

  global istutt41 istutt42
  
  global are_triangle_visible  are_ecartjustline_visible
  
  # Ne pas utiliser la derniere colonne de pitch.out si tutt41
  set is_pitch_ok 0
  if {$istutt41<1} {
  if { [catch {set pitch_file [open "pitch.out" r] } errormsg ]} {
    #error "Pb ouverture fichier pitch.out\n $errormsg"
    puts  "Pb ouverture fichier pitch.out\n $errormsg"
  } else {
    set is_pitch_ok 1
  }
  }
  if { [catch {set j_file [open "justess.out" r] } errormsg ]} {
    #error "Pb ouverture fichier justess.out\n $errormsg"
    puts  "Pb ouverture fichier justess.out\n $errormsg"
  } else {
    foreach ilist {rising_j failing_j Instrument_Screen_Width noms_notes NTESSC 
      activecolor accuracy_change} {
      global "$ilist"
    }
    # How many text lines for accuracy ?
    # Not too many : fit in the screenheight
    variable jheight0 [winfo screenheight .]
    # If dual screen, avoid > 1000 pixels
    if { $jheight0 > 1000} {set jheight0 1000}
    # Convert pixels into number of lines of "label" text 
    set jheight0 [expr {($jheight0-50)/[winfo reqheight .status_bar]}]
    # If NTESSC lines <<screenheight, don't use a big window
    if { $jheight0 > $NTESSC } {set jheight0 [expr {$NTESSC+1}]}
    variable jheight $jheight0
    set jheight $jheight0
    puts "height $jheight"
    #variable jheight $fingering_size
    variable x_j
    variable j [list ]
    variable i_line_j 0
    variable ligne
    variable j_max 0
    variable j_min 0
    variable tmpj
    variable jfullscale 0
    variable halfwidthhisto 200
    global STIM_ALL
    if {[winfo exists .visu_accuracy]} {
      if {[string equal $accuracy_change ""]>0} {
        # Do not recall  the window if exists and already up to date 
	return
      }
      variable w
      # Save geometry
      set accuracy_visu_namespace::wgeo_just "[wm geometry .visu_accuracy]"
      foreach w [winfo children .visu_accuracy] {
         destroy $w
       }
      after idle [wm geometry .visu_accuracy ""]
      wm withdraw .visu_accuracy
    } else {
      toplevel .visu_accuracy
      wm withdraw .visu_accuracy
      after idle [wm geometry .visu_accuracy [regsub {^[^x]*x[0-9]*([^0-9])} $accuracy_visu_namespace::wgeo_just {\1}]]
      after idle [wm geometry .visu_accuracy ""]
      wm protocol .visu_accuracy WM_DELETE_WINDOW {
        set accuracy_visu_namespace::wgeo_just "[wm geometry .visu_accuracy]"
        wm withdraw .visu_accuracy
      }
    }
    if {[string equal $accuracy_change "N"]>0} {
      set accuracy_change ""
    }
    wm title .visu_accuracy "Justesse + (Harmonicite) $accuracy_change"
    variable irow 0
    grid [tk::frame .visu_accuracy.aheadert] -column 0 -row $irow -sticky ns
    grid [tk::frame .visu_accuracy.aheaderg] -column 1 -columnspan 2 -row $irow -sticky nsw
    incr irow
    grid [tk::frame .visu_accuracy.jtextvals -background "green"] -column 0 -row $irow -sticky ns
    grid [tk::frame .visu_accuracy.graphical -background "blue"] -column 1 -columnspan 2 -row $irow -sticky nsw
    
    grid rowconfigure .visu_accuracy 0 -weight 0
    grid rowconfigure .visu_accuracy 1 -weight 1
    
    grid rowconfigure .visu_accuracy.jtextvals 1 -weight 1
    grid rowconfigure .visu_accuracy.graphical 1 -weight 1
    
    grid rowconfigure .visu_accuracy.aheadert 0 -weight 0
    grid rowconfigure .visu_accuracy.aheaderg 0 -weight 0
    set irow 0    
    grid [tk::text .visu_accuracy.aheadert.hjtextwidget -width 30 -height 1] -column 0 -row $irow -sticky ns
    grid rowconfigure .visu_accuracy.aheadert.hjtextwidget 0 -weight 1
    .visu_accuracy.aheadert.hjtextwidget insert 0.0 "Rang, Justesse: meas./calcul"
    grid [tk::text .visu_accuracy.aheaderg.agtextwidget -width 65 -height 1] -column 0 -row $irow -sticky ns

    .visu_accuracy.aheaderg.agtextwidget insert 0.0 " Critre d'harmonicit"

    canvas .visu_accuracy.aheaderg.agtextwidget.cci2 -height 7 -width [expr {2*$halfwidthhisto/15}] -bd 0 -cursor hand2
    .visu_accuracy.aheaderg.agtextwidget.cci2 create rectangle [expr {2*$halfwidthhisto/10}] 3 [expr {2*$halfwidthhisto/25}] 5 -fill white
    .visu_accuracy.aheaderg.agtextwidget window create 0.0 -window .visu_accuracy.aheaderg.agtextwidget.cci2 -align center 
    
        
    bind .visu_accuracy.aheaderg.agtextwidget.cci2 <1> ".visu_accuracy.aheaderg.agtextwidget.cci2check invoke"
    global are_ecartjustline_visible
    
    tk::checkbutton .visu_accuracy.aheaderg.agtextwidget.cci2check -variable are_ecartjustline_visible -cursor hand2 -command "
    foreach w \[winfo children .visu_accuracy.graphical.jgtextwidget\] {
    foreach curline \[\$w find withtag ecartjustline\] {
      \$w itemconfigure \$curline -state \[lindex {hidden normal} \$are_ecartjustline_visible\] 
    }
    }
    set accuracy_status \"\[lindex {Afficher Masquer} \$are_ecartjustline_visible\] les critres d'harmonicit sous forme de fines barres blanches\"
    bind .visu_accuracy.aheaderg.agtextwidget.cci2check <Enter> \"
        set old_accuracy_status \\\$accuracy_status
        set accuracy_status \\\"\[lindex {Afficher Masquer} \$are_ecartjustline_visible\] les critres d'harmonicit sous forme de fines barres blanches\\\"\"
    "
      bind .visu_accuracy.aheaderg.agtextwidget.cci2check <Enter> "
        set old_accuracy_status \$accuracy_status
        set accuracy_status \"\[lindex {Afficher Masquer} \$are_ecartjustline_visible\] les critres d'harmonicit sous forme de fines barres blanches\""
      bind .visu_accuracy.aheaderg.agtextwidget.cci2check <Leave> "
      set accuracy_status \"Cliquer sur une barre rouge de dviation de frquence pour calculer la note correspondante\""
    .visu_accuracy.aheaderg.agtextwidget window create 1.0 -window .visu_accuracy.aheaderg.agtextwidget.cci2check
    
    
    if {$is_pitch_ok} {
    #.visu_accuracy.aheaderg.agtextwidget insert 0.0 " Champ de libert   "
    .visu_accuracy.aheaderg.agtextwidget insert 0.0 " Libert "
    
    canvas .visu_accuracy.aheaderg.agtextwidget.cci3 -height 7 -width [expr {2*$halfwidthhisto/20}] -bd 0 -cursor hand2
     .visu_accuracy.aheaderg.agtextwidget.cci3 create poly [expr {2*$halfwidthhisto/25-4}] 7 [expr {2*$halfwidthhisto/25+4}] 7  [expr {2*$halfwidthhisto/25}] 2 -fill gold -outline black
    .visu_accuracy.aheaderg.agtextwidget window create 0.0 -window .visu_accuracy.aheaderg.agtextwidget.cci3 -align center 
    
    bind .visu_accuracy.aheaderg.agtextwidget.cci3 <1> ".visu_accuracy.aheaderg.agtextwidget.cci3check invoke"
     tk::checkbutton .visu_accuracy.aheaderg.agtextwidget.cci3check -variable are_triangle_visible -cursor hand2  -command "
    foreach w \[winfo children .visu_accuracy.graphical.jgtextwidget\] {
    foreach triangle \[\$w find withtag freedomtriangle\] {
      \$w itemconfigure \$triangle -state \[lindex {hidden normal} \$are_triangle_visible\] 
    }
    }
    set accuracy_status \"\[lindex {Afficher Masquer} \$are_triangle_visible\] les champs de libert sous forme de triangles\"
    bind .visu_accuracy.aheaderg.agtextwidget.cci3check <Enter> \"
        set old_accuracy_status \\\$accuracy_status
        set accuracy_status \\\"\[lindex {Afficher Masquer} \$are_triangle_visible\] les champs de libert sous forme de triangles\\\"\"
    "
    .visu_accuracy.aheaderg.agtextwidget window create 1.0 -window .visu_accuracy.aheaderg.agtextwidget.cci3check
    
      bind .visu_accuracy.aheaderg.agtextwidget.cci3check <Enter> "
        set old_accuracy_status \$accuracy_status
        set accuracy_status \"\[lindex {Afficher Masquer} \$are_triangle_visible\] les champs de libert sous forme de triangles\""
      bind .visu_accuracy.aheaderg.agtextwidget.cci3check <Leave> "
      set accuracy_status \"Cliquer sur une barre rouge de dviation de frquence pour calculer la note correspondante\""
    }

    .visu_accuracy.aheaderg.agtextwidget insert 0.0 " Ecart justesse "

    canvas .visu_accuracy.aheaderg.agtextwidget.cci -height 7 -width [expr {2*$halfwidthhisto/12}] -bd 0
    .visu_accuracy.aheaderg.agtextwidget.cci create rectangle [expr {2*$halfwidthhisto/20}] 1 [expr {2*$halfwidthhisto/15}] 7 -fill red
    .visu_accuracy.aheaderg.agtextwidget window create 0.0 -window .visu_accuracy.aheaderg.agtextwidget.cci -align center 

    
    incr irow
    #grid [tk::scrollbar .visu_accuracy.jtextvals.sjtxtbar -orient vertical -command {accuracy_dualview} ] -column 1 -row $irow -sticky ns
    #grid [tk::scrollbar .visu_accuracy.graphical.sjgtxtbar -orient vertical -command {accuracy_dualview}] -column 1 -row $irow -sticky ns
    grid [tk::scrollbar .visu_accuracy.sjgtxtbar -orient vertical -command {accuracy_dualview}] -column 3 -row $irow -sticky ns
    grid columnconfigure .visu_accuracy 0 -weight 0
    grid columnconfigure .visu_accuracy 1 -weight 1
    grid columnconfigure .visu_accuracy 2 -weight 0
    grid columnconfigure .visu_accuracy 3 -weight 0
    grid [tk::text .visu_accuracy.jtextvals.jtextwidget -width 30 -height $jheight -yscrollcommand {accuracy_dualscroll}] -column 0 -row $irow -sticky ns
    grid rowconfigure .visu_accuracy.jtextvals.jtextwidget 0 -weight 1
    
    grid [tk::text .visu_accuracy.graphical.jgtextwidget -width 65 -height $jheight -yscrollcommand {accuracy_dualscroll}] -column 0 -row $irow -sticky nsw
    grid rowconfigure .visu_accuracy.graphical.jgtextwidget 0 -weight 1
    
    global accuracy_status
    global old_accuracy_status
    set accuracy_status "Cliquer sur une barre rouge de dviation de frquence pour calculer la note correspondante"
    set old_accuracy_status $accuracy_status
    
    grid [ttk::separator .visu_accuracy.accuracy_status_separator -orient horizontal]  -column 0 -row [incr irow] -columnspan 3 -sticky we
    grid [tk::label .visu_accuracy.accuracy_status -textvariable accuracy_status] -column 0 -row [incr irow] -columnspan 2 -sticky nsw
    grid [tk::button .visu_accuracy.help -text "?" -command "open_help_window {accuracy}"]  -column 2 -columnspan 2 -row $irow -padx 0 -pady 0 -ipadx 0 -ipady 0
    after idle [wm geometry .visu_accuracy ""]
    update idletasks
    variable lastx 0
    variable lastj 0
    variable curx 0
    variable curnote ""
    while {[gets $j_file ligne] >=0} {
      if {$is_pitch_ok>0} {
        if {[gets $pitch_file ligne_pitch]<0} {
          set is_pitch_ok 0
        }
      }
      incr i_line_j
      set tmpj [lindex $ligne 1]
      lappend j $tmpj
      if {$tmpj>$j_max} {
        set j_max $tmpj
      }
      if {$tmpj<$j_min} {
        set j_min $tmpj
      }
      set lastx [lindex $ligne 0]
      lappend x_j $lastx
      set lastj $tmpj
      # Print the current line in the text edition widget
      #.visu_accuracy.jtextvals.jtextwidget insert $i_line_j.0 "[format {%g} [lindex $ligne 0]]\t[format {%10.0f} $tmpj]\n"
      .visu_accuracy.jtextvals.jtextwidget insert $i_line_j.0 "$ligne\n"
      if {[llength $noms_notes]>[expr {$i_line_j-1}]} {
        set curnote [regsub -all {'} [lindex $noms_notes [expr {$i_line_j-1}]] {}]
      }
      .visu_accuracy.graphical.jgtextwidget insert $i_line_j.0 "$curnote\n"
      #.visu_accuracy.graphical.jgtextwidget insert $i_line_j.0 "\n"
      canvas .visu_accuracy.graphical.jgtextwidget.cc$i_line_j -height 7 -width [expr {2*$halfwidthhisto}] -bd 0
      variable curacur
      set curacur [lindex $ligne 2]
      if {[string is double $curacur] && $curacur == $curacur} {
        .visu_accuracy.graphical.jgtextwidget.cc$i_line_j create rectangle $halfwidthhisto 1 [expr {((100+[lindex $ligne 2])*$halfwidthhisto/100)}] 7 -fill red
      } else {
        .visu_accuracy.graphical.jgtextwidget.cc$i_line_j create rectangle 0 1 [expr {2*$halfwidthhisto}] 7 -fill black
      }

      if {$is_pitch_ok>0} {
        set cur_lib [lindex $ligne_pitch [expr {[llength $ligne_pitch]-1}]]
	set cur_lib [string map {"*" "" } $cur_lib]
	#puts "cur_lib=$cur_lib"
	if {$cur_lib>0} {
	  set abs_lib [expr {$cur_lib/2}]
	  #.visu_accuracy.graphical.jgtextwidget.cc$i_line_j create rectangle [expr {((100+[lindex $ligne 2]-$abs_lib)*$halfwidthhisto/100)}] 3 [expr {((100+[lindex $ligne 2]+$abs_lib)*$halfwidthhisto/100)}] 8 -fill orange
          .visu_accuracy.graphical.jgtextwidget.cc$i_line_j create poly [expr {((100+[lindex $ligne 2]-$abs_lib)*$halfwidthhisto/100)}] 1 [expr {((100+[lindex $ligne 2]+$abs_lib)*$halfwidthhisto/100)}] 1  [expr {((100+[lindex $ligne 2])*$halfwidthhisto/100)}] 6 -fill gold -outline black -tags freedomtriangle -state hidden 
	} else {
	  set abs_lib [expr {-$cur_lib/2}]
	  #.visu_accuracy.graphical.jgtextwidget.cc$i_line_j create rectangle [expr {((100+[lindex $ligne 2]-$abs_lib)*$halfwidthhisto/100)}] 0 [expr {((100+[lindex $ligne 2]+$abs_lib)*$halfwidthhisto/100)}] 5 -fill orange
          .visu_accuracy.graphical.jgtextwidget.cc$i_line_j create poly [expr {((100+[lindex $ligne 2]-$abs_lib)*$halfwidthhisto/100)}] 7 [expr {((100+[lindex $ligne 2]+$abs_lib)*$halfwidthhisto/100)}] 7  [expr {((100+[lindex $ligne 2])*$halfwidthhisto/100)}] 2 -fill gold -outline black -tags freedomtriangle -state hidden
	}
      }
      
      if {[llength $STIM_ALL]>1} {
        if {[llength $STIM_ALL]>[expr {[lindex $ligne 0]-1}]} {
          .visu_accuracy.graphical.jgtextwidget.cc$i_line_j create rectangle [expr {2*$halfwidthhisto}] 3 [expr {2*$halfwidthhisto-10000*[lindex $STIM_ALL [expr {[lindex $ligne 0]-1}]]}] 5 -fill white -tags ecartjustline
	}
      }
      .visu_accuracy.graphical.jgtextwidget window create $i_line_j.0 -window .visu_accuracy.graphical.jgtextwidget.cc$i_line_j -align center 
      
      
      
      bind .visu_accuracy.graphical.jgtextwidget.cc$i_line_j <1> "
      set lastuserin $i_line_j
      calculate 1 $i_line_j"
      .visu_accuracy.graphical.jgtextwidget.cc$i_line_j configure -cursor hand2
      if {$is_pitch_ok>0} {
        bind .visu_accuracy.graphical.jgtextwidget.cc$i_line_j <Enter> "
        set old_accuracy_status \$accuracy_status
        set accuracy_status \"Calculer la note $curnote de rang [lindex $ligne 0] et d'harmonicite [lindex $STIM_ALL [expr {[lindex $ligne 0]-1}]], champ de liberte $cur_lib \""
      } else {
        bind .visu_accuracy.graphical.jgtextwidget.cc$i_line_j <Enter> "
        set old_accuracy_status \$accuracy_status
        set accuracy_status \"Calculer la note $curnote de rang [lindex $ligne 0] et d'harmonicite [lindex $STIM_ALL [expr {[lindex $ligne 0]-1}]]\""
      }
      bind .visu_accuracy.graphical.jgtextwidget.cc$i_line_j <Leave> "
      set accuracy_status \$old_accuracy_status"
      #if {[string equal $accuracy_change "*"]>0} {
        .visu_accuracy.graphical.jgtextwidget configure -background [lindex {"white" "darkgrey"} [string equal $accuracy_change "*"]]
      #} else
      
      # -stretch 1
    }
    close $j_file

    close $pitch_file
    
    # Number of lines should match NTESSC
     if {[lsearch -exact -integer $i_line_j $NTESSC]<0} { 
        set accuracy_change "*"
        wm title .visu_accuracy "Justesse + (Harmonicite) $accuracy_change"
      }
    if {$i_line_j<1} {
      puts "Empty file justess.out"
      withdraw .visu_accuracy
    } else {
      .visu_accuracy.jtextvals.jtextwidget delete end-1c end
      .visu_accuracy.graphical.jgtextwidget delete end-1c end
      puts "ok acc"
      # update visibility
      .visu_accuracy.aheaderg.agtextwidget.cci3check invoke
      .visu_accuracy.aheaderg.agtextwidget.cci3check invoke
      .visu_accuracy.aheaderg.agtextwidget.cci2check invoke
      .visu_accuracy.aheaderg.agtextwidget.cci2check invoke

      after idle [wm geometry .visu_accuracy [regsub {^[^x]*x[0-9]*([^0-9])} $accuracy_visu_namespace::wgeo_just {\1}]]
      wm deiconify .visu_accuracy
      raise .visu_accuracy
      focus .visu_accuracy
      #wm geometry .visu_accuracy ""wm geometry .visu_accuracy [regsub {^[^x]*x[0-9]*([^0-9])} $accuracy_visu_namespace::wgeo_just {\1}]
      
      #after idle [update]
      #after idle [wm geometry .visu_accuracy [regsub {^[^x]*x[0-9]*([^0-9])} $accuracy_visu_namespace::wgeo_just {\1}]]
      #after idle [wm geometry .visu_accuracy ""]
      set accuracy_status "Cliquer sur une barre rouge de dviation de frquence pour calculer la note correspondante"
      set old_accuracy_status $accuracy_status
    
      puts "geo_a [wm geometry .visu_accuracy]"
      #after idle [wm geometry .visu_accuracy [wm geometry .visu_accuracy]]
    }
  }
}

    
}

set wgeo_efing ""
set wgeo_flaedit ""

# Edition des doigts /Fingering
namespace eval edit_fingering_namespace {

proc image_staff_g_clef {c xi yi ys} {
  # Porte / Staff
  for {set ifor 0} {$ifor<5} {incr ifor} {
    $c create line [::exprall "{$xi}   {$yi+$ifor*$ys}   {$xi+$ys*8}   {$yi+$ifor*$ys}"]
  }
  #Cl de sol / Treble clef / G clef
  $c create arc  [::exprall "{$xi+2*$ys}   {$yi+3*$ys}   {$xi+3*$ys}   {$yi+2*$ys}"] -style arc -start  90 -extent 180
  $c create arc  [::exprall "{$xi+$ys}     {$yi+4*$ys}   {$xi+3*$ys}   {$yi+2*$ys}"] -style arc -start 150 -extent 300
  $c create line [::exprall "{$xi+1.1*$ys} {$yi+2.5*$ys} {$xi+2.5*$ys} {$yi+0*$ys}"] 
  $c create arc  [::exprall "{$xi+1.8*$ys} {$yi+0.5*$ys} {$xi+2.6*$ys} {$yi-1.5*$ys}"] -style arc -start -30 -extent 210
  $c create line [::exprall "{$xi+1.8*$ys} {$yi-0.5*$ys} {$xi+2.5*$ys} {$yi+5*$ys}"]
  $c create arc  [::exprall "{$xi+2.5*$ys} {$yi+4.5*$ys} {$xi+1.5*$ys} {$yi+5.5*$ys}"] -style arc -start 180 -extent 190
  $c create oval [::exprall "{$xi+1.5*$ys} {$yi+5.1*$ys} {$xi+2*$ys}   {$yi+4.6*$ys}"] -fill black
}

proc degree1Hz_update {newNTESSB} {
  # Frequency update
  global degree1Hz
  global semitone
  global newFLA
  #$semitone*log($tmpexpectedw/$dpiFLA)+$NTESSB+1=degree
  set degree1Hz [format {%.2f} [expr {$newFLA*exp(-$newNTESSB/$semitone)}]]
}


proc majdegree1gui {c xi yi ys newNTESSB degree} {
  #Nombre de demi-tons en dessous du LA
  set notedd1 [expr {(($newNTESSB+1200+4+$degree)%12-5)}]
  
  set icorneg 1
  if {$notedd1<0} {
  incr icorneg -2
  }
  set noted1 [expr {(($notedd1+1.0*(($notedd1%2)*$icorneg))/4)}]
  
  set sharpmol [expr {-((abs(($notedd1-2+5)%12-5)%5)>2)+(($notedd1%12)%7)%2}]
  if {[expr {abs($sharpmol)>0}]} {
    set xi [expr {$xi+$ys/2}]
  }
  
  # Clean previous note
  $c delete degree1gui
  # Draw note
  $c create oval [::exprall "{$xi+5*$ys} {$yi+($noted1+2)*$ys} {$xi+6*$ys} {$yi+($noted1+3)*$ys}"] -fill black -tag degree1gui
  $c create line [::exprall "{$xi+6*$ys} {$yi+($noted1-2)*$ys} {$xi+6*$ys} {$yi+($noted1+2.5)*$ys}"] -fill black -tag degree1gui  
  
  set wlines [expr {int(($ys-1)/6)+1}]
  
  if {$sharpmol>0} {
    #Sharp
    foreach ifor {0 1} {
      $c create line [::exprall "{$xi+(4.2-0.4*$ifor)*$ys} {$yi+($noted1+1.5+0.2*$ifor)*$ys} {$xi+(4.2-0.4*$ifor)*$ys} {$yi+($noted1+3.5+0.2*$ifor)*$ys}"] -fill black -tags degree1gui
      $c create line [::exprall "{$xi+(3.4)*$ys}  {$yi+($noted1+3.2-$ifor)*$ys}  {$xi+(4.6)*$ys}  {$yi+($noted1+2.8-$ifor)*$ys}"] -fill black -width $wlines -tags degree1gui
    }

  } elseif {$sharpmol<0} {
    #Mol
    $c create line [::exprall "{$xi+4*$ys}  {$yi+($noted1+0.5)*$ys} {$xi+4*$ys}   {$yi+($noted1+3)*$ys}"] -fill black -tags degree1gui
    $c create arc [::exprall "{$xi+0.5*$ys} {$yi+($noted1+3.4)*$ys} {$xi+4.5*$ys} {$yi+($noted1+1.4)*$ys}"] -style arc -start -42 -extent 60 -width $wlines -tags degree1gui
    $c create arc [::exprall "{$xi+3.8*$ys} {$yi+($noted1+3)*$ys}   {$xi+4.5*$ys} {$yi+($noted1+2)*$ys}"] -style arc -start 110 -extent -90 -width $wlines -tags degree1gui
  }
  
  # Frequency update
  degree1Hz_update $newNTESSB
}

proc editfla {} {
  foreach ilist {FLA NTESSB newFLA newNTESSB ITMPNT newITMPNT} {
    global $ilist
  }
  
  set newFLA $FLA
  set newNTESSB $NTESSB
  # Force integer (to match string value of the radiobutton)
  set newITMPNT 0
  if {$ITMPNT>0.5} {
    incr newITMPNT
  }
  update_ITMPNT $newITMPNT
  
  global wgeo_flaedit
  if {[winfo exists .visu_flaedit]} {
    set wgeo_flaedit "[wm geometry .visu_flaedit]"
    variable w
    foreach w [winfo children .visu_flaedit] {
      destroy $w
    }
  } else {
    toplevel .visu_flaedit
    wm protocol .visu_flaedit WM_DELETE_WINDOW {
      set wgeo_flaedit "[wm geometry .visu_flaedit]"
      wm withdraw .visu_flaedit
    }
  }
  wm title .visu_flaedit {Note et frquence de rfrence, Temprament}
  
  set irow 0
  
  # xi, ti initial position
  # ys : space between horizontal lines
  set xi 35
  set yi 30
  set ys 8
  grid [tk::canvas .visu_flaedit.degreefla -width 180 -height [expr {10*$ys}]] -column 1 -row $irow -columnspan 2 -rowspan 2
  
  # Porte Cl de sol :
  image_staff_g_clef .visu_flaedit.degreefla $xi $yi $ys
  # Note LA (A)
  .visu_flaedit.degreefla create oval [::exprall "{$xi+5*$ys} {$yi+2*$ys} {$xi+6*$ys} {$yi+3*$ys}"] -fill black
  .visu_flaedit.degreefla create line [::exprall "{$xi+6*$ys} {$yi-$ys}   {$xi+6*$ys} {$yi+2.5*$ys}"] -fill black
  
  # Diapason / Tuning Fork
  .visu_flaedit.degreefla create oval 05 52 09 48 -fill DarkSlateGrey -outline DarkSlateGrey -tags flaedit
  foreach ilfork "
  {07 50 14 43}
  {14 39 24 29}
  {18 43 28 33}" {
  .visu_flaedit.degreefla create line {*}$ilfork -width 3 -fill DarkSlateGrey -tags flaedit
  }
  .visu_flaedit.degreefla create arc 13 38 19 44 -start 135 -extent 180 -style arc -width 3 -outline DarkSlateGrey -tags flaedit
    
  set yi [expr {4*$ys}]

  set irow 0
  set icol 4
  grid [tk::canvas .visu_flaedit.degre1 -width 180 -height [expr {10*$ys}]] -column $icol -row $irow -rowspan 2
  grid [tk::frame .visu_flaedit.framedegree1Hz] -column $icol -row [incr irow 2]
  
  global degree1Hz
  set degree1Hz 0
  
  grid [tk::label .visu_flaedit.framedegree1Hz.labeldegree1Hzval -textvariable degree1Hz] -column 0 -row 0
  grid [tk::label .visu_flaedit.framedegree1Hz.labeldegree1Hzunit -text " Hz"] -column 1 -row 0
  grid [tk::label .visu_flaedit.labeldegree1 -text "Degr\n1"] -column $icol -row [incr irow]
    #Dessin de la note degr 1
  
  image_staff_g_clef .visu_flaedit.degre1 $xi $yi $ys
  majdegree1gui .visu_flaedit.degre1 $xi $yi $ys $newNTESSB 1

  set icol 0
  set irow 0
  set icmd "if {\[string equal \$newNTESSB \"\"\]} {set newNTESSB 0}
  edit_fingering_namespace::majdegree1gui .visu_flaedit.degre1 $xi $yi $ys \$newNTESSB 1"
  
  grid [tk::label .visu_flaedit.flaname -text "FLA"] -column $icol -row [incr irow 2]
  grid [tk::frame .visu_flaedit.flaHzframe] -column [incr icol]  -row $irow
  grid [tk::entry .visu_flaedit.flaHzframe.flaval -textvariable newFLA -width 6 -validate focus -validatecommand "$icmd;return 1"] -column 0 -row 0
  bind .visu_flaedit.flaHzframe.flaval <Return> "$icmd"
  grid [tk::label .visu_flaedit.flaHzframe.flaunit -text "Hz"] -column 1 -row 0 -sticky w
  set icol 0
  grid [tk::label .visu_flaedit.fladegreelabel -text "Degr\n1 + NTESSB"] -column [incr icol] -row [incr irow]
  
  grid [tk::button .visu_flaedit.changeHz -text "Appliquer les changements" -command "
  if {\[string equal \$newFLA \$FLA\]} {} else {
  set FLA \$newFLA
  geofingeringchanged
  }
  $icmd
  if {\[string equal \$newNTESSB \$NTESSB\]} {} else {
  set NTESSB \$newNTESSB
  geofingeringchanged
  }
  "] -sticky e -column 0 -row [incr irow] -columnspan 4 -pady 5
  
  grid [tk::button .visu_flaedit.cancelHz -text "Annuler les changements" -command "
  set newNTESSB \$NTESSB
  set newFLA \$FLA
  $icmd
  "] -sticky we -column 4 -row $irow
  
  grid [ttk::separator .visu_flaedit.separtemp -orient horizontal] -column 0 -row [incr irow] -columnspan 5 -sticky we -pady 20
  
  grid [tk::frame .visu_flaedit.temperamentframe] -column 0 -row [incr irow] -columnspan 4
  grid [tk::label .visu_flaedit.temperamentframe.labeltemperament -text "Choix du temprament : ( ITMPNT = "] -column 0 -row 0 -sticky e
  grid [tk::label .visu_flaedit.temperamentframe.valcurtemperament -textvariable ITMPNT] -column 1 -row 0 -sticky w
  grid [tk::label .visu_flaedit.temperamentframe.parenthesetemperament -text ")"] -column 2 -row 0 -sticky e
  incr irow
  # Porte Cl de sol, Note LA (A) pour chaque temprament
  foreach ifor {0 1} {
    grid [tk::canvas .visu_flaedit.temperament$ifor -width 180 -height [expr {10*$ys}]] -column [expr {3*(1-$ifor)}] -row $irow -columnspan [expr {1+2*$ifor}]
    image_staff_g_clef .visu_flaedit.temperament$ifor $xi $yi $ys
    .visu_flaedit.temperament$ifor create oval [::exprall "{$xi+5*$ys} {$yi+2*$ys} {$xi+6*$ys} {$yi+3*$ys}"] -fill black
    .visu_flaedit.temperament$ifor create line [::exprall "{$xi+6*$ys} {$yi-2*$ys} {$xi+6*$ys} {$yi+2.5*$ys}"] -fill black  
    # Autre note juste
    .visu_flaedit.temperament$ifor create oval [::exprall "{$xi+5*$ys} {$yi+(1.5*$ifor-0.5)*$ys} {$xi+6*$ys} {$yi+(1.5*$ifor-1.5)*$ys}"] -fill black
  }
  .visu_flaedit.temperament0 create line [::exprall "{$xi+4.5*$ys} {$yi-$ys} {$xi+6.5*$ys} {$yi-$ys}"]
  grid [tk::radiobutton .visu_flaedit.choixt0 -text "Quintes justes : Hz * 1.5\n(Utilisation dconseille)"   -variable newITMPNT -value 0 -command "
  if {\$ITMPNT>0} {update_ITMPNT 0;edit_fingering_namespace::degree1Hz_update \$newNTESSB;geofingeringchanged};return 1
  "] -column 0 -row [incr irow] -columnspan 3 
  grid [tk::radiobutton .visu_flaedit.choixt1 -text "Octaves justes : Hz * 2\n(Choix recommand)" -variable newITMPNT -value 1 -command "
  if {\$ITMPNT<1} {update_ITMPNT 1;edit_fingering_namespace::degree1Hz_update \$newNTESSB;geofingeringchanged};return 1
  "] -column 3 -row $irow
  
  set irow 0

  global fontspin

  # Aide sur les degrs / Help on Degrees
  grid [tk::label .visu_flaedit.degreexplained1 -text "# : Degr -> Degr + 1"] -column [incr icol 1] -row $irow -columnspan 2
  grid [tk::label .visu_flaedit.degreexplained2 -text "b : Degr -> Degr - 1"] -column $icol -row [incr irow] -columnspan 2

  grid [tk::label .visu_flaedit.notationNTESSB -text "NTESSB"] -column $icol -row [incr irow] -columnspan 2

  grid [tk::frame .visu_flaedit.spinhelpfladeree] -column $icol -row [incr irow] -columnspan 2
  grid [tk::spinbox .visu_flaedit.spinhelpfladeree.spinfladegree -textvariable newNTESSB -from -1000 -to 1000 -increment 1 -format {%.0f} -width 6 -textvariable newNTESSB -font $fontspin -justify right -command "
  $icmd
  " -validatecommand "$icmd;return 1" -validate focus] -column 0 -row 0 -columnspan 2
  bind .visu_flaedit.spinhelpfladeree.spinfladegree <Return> "$icmd"
  
  grid [tk::button .visu_flaedit.spinhelpfladeree.help -text "?" -command "open_help_window {finger}"] -column 2  -row 0
    
  
  update idletasks
  wm deiconify .visu_flaedit
  wm geometry .visu_flaedit [regsub {^[^x]*x[0-9]*([^0-9])} $wgeo_flaedit {\1}]
  wm geometry .visu_flaedit ""
  raise .visu_flaedit
  focus .visu_flaedit
}



proc end_fingering_proc {} {
# Dummy proc, can be replaced by a real one by a macro, 
# see at the bottom of this source file "Run macro if asked"
}

proc edit_fingering {basefinger} {
  foreach ilist {L D0P IFLUTE fingering_size NTESSC noms_notes degres_tessiture_notes refdoigte_notes id_Hole
  edit_finger_status 	idframefinger 	pendingact
  idprec idsuiv
  difirstvis dnbvis
  activecolor
  wgeo_efing} {
    global "$ilist"
  }
  
  variable ifor
  variable ltktype
  
  if {$basefinger<0} {
    if {[winfo exists .visu_edit_fingering]} {
      set wgeo_efing "[wm geometry .visu_edit_fingering]"
      destroy .visu_edit_fingering
     }
    toplevel .visu_edit_fingering
    wm geometry .visu_edit_fingering [regsub {^[^x]*x[0-9]*([^0-9])} $wgeo_efing {\1}]
    wm geometry .visu_edit_fingering ""
    
    wm title .visu_edit_fingering {Doigts}
    wm protocol .visu_edit_fingering WM_DELETE_WINDOW {
      global wgeo_efing
      set wgeo_efing "[wm geometry .visu_edit_fingering]"
      wm withdraw .visu_edit_fingering
    }
    #wm geometry .visu_edit_fingering ""
    variable irow 0
    #grid [tk::label .visu_edit_fingering.nota -text "Nota : les trous ne sont pas  l'chelle" -font {-slant italic}] -column 0 -columnspan 2 -row $irow
    grid [tk::canvas .visu_edit_fingering.top -width 30 -height 3] -column 0 -columnspan 2 -row $irow
    grid [tk::frame .visu_edit_fingering.left] -column 0 -row [incr irow] -sticky nse
    grid [tk::frame .visu_edit_fingering.right -borderwidth 2 -relief sunken] -column 1 -row $irow -sticky w
    grid [tk::frame .visu_edit_fingering.tmpright -borderwidth 2 -relief sunken] -column 2 -row $irow -sticky w
    variable iirow 0
    grid [tk::label .visu_edit_fingering.left.note  -text "Note" ] -column 0 -row $iirow       -sticky ne
    grid [tk::label .visu_edit_fingering.left.degre -text "Degr"] -column 0 -row [incr iirow] -sticky ne
    grid [tk::label .visu_edit_fingering.left.measjust -text "Justesse\nmesure"] -column 0 -row [incr iirow] -sticky ne
    grid [tk::canvas .visu_edit_fingering.left.flaedit -width 30 -height 30 -relief raised -borderwidth 2 -takefocus 1] -column 0 -row [incr iirow] -sticky n
    grid [tk::label .visu_edit_fingering.left.nota  -text "\n\nNota :\n\nles\ntrous\nne\nsont\npas\n\nl'chelle\n\n\n\n\n\n\n\n\n\n\n\n"] -column 0 -row [incr iirow] -sticky n
    grid [tk::label .visu_edit_fingering.left.rank  -text "Rang"] -column 0 -row [incr iirow] -sticky se
    
    grid rowconfigure .visu_edit_fingering.right 0 -weight 0
    grid columnconfigure .visu_edit_fingering.left 0 -weight 1
    
    foreach ifor {0 1 2 3} {
      grid rowconfigure .visu_edit_fingering.left $ifor -weight 0
    }
    grid rowconfigure .visu_edit_fingering.left 3 -weight 1
    
    # Diapason / Tuning Fork
    .visu_edit_fingering.left.flaedit create rectangle 0 0 35 35 -activefill white -tags flarect
    .visu_edit_fingering.left.flaedit create oval 5 27 9 23 -fill DarkSlateGrey -outline DarkSlateGrey -tags flaedit
    foreach ilfork "
    {7 25 14 18}
    {14 14 24 4}
    {18 18 28 8}" {
      .visu_edit_fingering.left.flaedit create line {*}$ilfork -width 3 -fill DarkSlateGrey -tags flaedit
    }
    .visu_edit_fingering.left.flaedit create arc 13 13 19 19 -start 135 -extent 180 -style arc -width 3 -outline DarkSlateGrey -tags flaedit
    
    #.visu_edit_fingering.left.flaedit bind flaedit <1> "::edit_fingering_namespace::editfla"
    foreach ifor {<1> <Return> <space>} {
      bind .visu_edit_fingering.left.flaedit $ifor "::edit_fingering_namespace::editfla"
    }
    bind .visu_edit_fingering.left.flaedit <Enter> "
    .visu_edit_fingering.left.flaedit itemconfigure flarect -fill white
    set old_edit_finger_status \$edit_finger_status
    set edit_finger_status \"Edition de la frquence de rfrence, note de degr 1 et temprament\""
    bind .visu_edit_fingering.left.flaedit <Leave> "
    .visu_edit_fingering.left.flaedit itemconfigure flarect -fill {}
    set edit_finger_status \$old_edit_finger_status"
    
    grid [tk::frame .visu_edit_fingering.commands] -column 1 -columnspan 1 -row [incr irow] -sticky w
    grid [tk::button .visu_edit_fingering.help -text "?" -command "open_help_window {finger}"] -column 0 -columnspan 1 -row $irow
    
    set iirow 0
    set iicol 0
    grid   [tk::scale .visu_edit_fingering.commands.scrollfinger -from 0 -to [expr {$NTESSC-2}] -resolution 1 -variable difirstvis -orient horizontal -showvalue false -command {edit_fingering_namespace::ifvselect_vis_fingering} ] -column $iicol -row $iirow -sticky ws
    grid [tk::label .visu_edit_fingering.commands.comedstatusbar -text "Prochain clic : "] -column [incr iicol] -row $iirow -sticky w
    
    foreach ifor {
      {addfinger    -text "Dupliquer un doigt"}
      {supprfinger  -text "X Supprimer un doigt"}
      {calcfinger   -text "Calculer un doigt"}
      {supplement}
      {cancelaction -text "Ne rien faire"} 
    } {
      set ltktype button
      if {[string equal [lindex $ifor 0] "supplement"]} {
	set ltktype frame
      }
      grid [eval "tk::$ltktype .visu_edit_fingering.commands.$ifor"] -column [incr iicol] -row $iirow -sticky w
    }
    
    set edit_finger_status ""
    grid [tk::label .visu_edit_fingering.commands.edstatusbar -textvariable edit_finger_status] -column [incr iicol] -row $iirow -sticky w
  
    .visu_edit_fingering.commands.cancelaction configure -command "set edit_finger_status \"\"
    focus .visu_edit_fingering
    set pendingact \[list {#} {#} {#}\]"
  
    .visu_edit_fingering.commands.addfinger configure -command "set edit_finger_status \"Slectionner le Rang  dupliquer\"
    set pendingact \[list {edit_fingering_namespace::enter_add} {edit_fingering_namespace::add_fingering} {edit_fingering_namespace::leave_add}\]"
    
    .visu_edit_fingering.commands.supprfinger configure -command "set edit_finger_status \"Slectionner le Rang  supprimer\"
    set pendingact \[list {edit_fingering_namespace::enter_suppr} {edit_fingering_namespace::suppr_fingering} {edit_fingering_namespace::leave_suppr}\]"

    .visu_edit_fingering.commands.calcfinger configure -command "set edit_finger_status \"Slectionner le rang du doigt  calculer\"
    set pendingact \[list {edit_fingering_namespace::enter_calc} {edit_fingering_namespace::calc_fingering} {edit_fingering_namespace::leave_calc}\]"

    #bind .visu_edit_fingering <Escape> "puts echappee
    #set edit_finger_status \"\"
    #set pendingact \[list {#} {#} {#}\]"
  
    #bind .visu_edit_fingering <Delete> "
    #set edit_finger_status \"Slectionner le Rang  supprimer\"
    #set pendingact \[list {edit_fingering_namespace::enter_suppr} {edit_fingering_namespace::suppr_fingering} {edit_fingering_namespace::leave_suppr}\]"
    
    #bind .visu_edit_fingering <F2> "
    #set edit_finger_status \"Slectionner le Rang  dupliquer\"
    #set pendingact \[list {edit_fingering_namespace::enter_add} {edit_fingering_namespace::add_fingering} {edit_fingering_namespace::leave_add}\]"
    

    grid [tk::frame .visu_edit_fingering.tmpright.framefingernul]
    
    set iirow -1
    foreach ifor {getNote getDegre getJust} {
      grid   [tk::entry .visu_edit_fingering.tmpright.framefingernul.$ifor -text "" -width 5 ] -column $iicol -row [incr iirow] -sticky n
    }
    grid  [tk::canvas .visu_edit_fingering.tmpright.framefingernul.fingers -width 50 -height $fingering_size] -column $iicol -row [incr iirow] -sticky n
    
    grid   [tk::label .visu_edit_fingering.tmpright.framefingernul.rank -text "" -width 3] -column $iicol -row [incr iirow] -sticky s
    
    foreach ifor {0 1 2 3}  {
      grid rowconfigure .visu_edit_fingering.tmpright.framefingernul $ifor -weight 0
    }
  
    set basefinger 0
  } else {    
    if {[winfo exists .visu_edit_fingering]} {
      set wgeo_efing "[wm geometry .visu_edit_fingering]"
      wm geometry .visu_edit_fingering ""
    }
    grid .visu_edit_fingering.tmpright
    destroy .visu_edit_fingering.right
    grid [tk::frame .visu_edit_fingering.right -borderwidth 2 -relief sunken] -column 1 -row 1 -sticky w
    grid rowconfigure .visu_edit_fingering.right 0 -weight 0
  }
  
  # Looking for indexes of first (ltroud) and last (ltrouf) non-zero holes
  variable ltroud [lsearch -exact -real -not $D0P 0]
  if {$ltroud<0} {set ltroud 0}
  
  # Do not look at L section before the first hole
  incr ltroud 1
  
  variable ltrouf [lsearch -exact -real -not -start [expr {($IFLUTE<1)+1}] [lreverse $D0P] 0]
  puts "IFLUTE $IFLUTE $ltrouf"
  if {$ltrouf<0} {set ltrouf 0}
  set ltrouf [expr {[llength $D0P]-1-$ltrouf}]
  set hzoom 10
  puts "$ltroud -> $ltrouf"
  set dzoom [expr {[::tcl::mathop::+ {*}[lrange $L $ltroud $ltrouf]]}]
  if {0==$dzoom} {
    set dzoom 1
  }
  set dzoom [expr {1.0*($fingering_size-4*$hzoom)/$dzoom}]
  #set dzoom [expr 1.0*($fingering_size-4*$hzoom)/[::tcl::mathop::+ {*}[lrange $L $ltroud $ltrouf]]]

   #Definition of represented holes
  variable ldtrou [list ]
  variable ldiT [list ]
  # Normalization constants for hole represented size
  
  # Look at the diameter ofthe first hole (which was skipped for L)
  incr ltroud -1
  variable nzhole [lsearch -all -inline -exact -real -not [lrange $D0P $ltroud $ltrouf] 0]
  incr ltroud
  variable nznb [llength $nzhole]
  variable tmpmedian [lindex [lsort $nzhole] [expr {int(floor((0.5+$nznb)/2))}]]
  variable pseudovar 0
  variable ifor 0
  variable divideval 0.001
  foreach iT $nzhole {
    set pseudovar [expr {$pseudovar+$ifor*($nznb-$ifor)*abs($iT-$tmpmedian)}]
    set divideval [expr {$divideval+$ifor*($nznb-$ifor)}]
    incr ifor
  }
  set pseudovar [expr {$pseudovar/$divideval/2}]
  if {$pseudovar==0} {set pseudovar 1}
  puts "mediane $tmpmedian pseudovar $pseudovar"
  
  variable hP $fingering_size
  variable hhzoom 0
  variable xcent0 25
  variable xcent $xcent0
  incr xcent -5
  variable altern 10
  # xcent : will always altern left/right
  # By default, each hole is placed the opposite side from the previous
  # exception : if no overlap with neighbouring holes (previous and next), the hole is centered
  variable xcentcur 0
  
  variable hhzooms [list ]
  variable hPs [list ]
  variable xcents [list ]
  
  set ifor 0
  variable ifor2 0

  # Lower bound of the previous hole
  variable lastholelower [expr {2*$fingering_size}]
  # Lower bound of the hole before the previous one
  variable beforelastholelower $lastholelower
  # gap1 = 1 if the gap between the two former holes is positive
  variable gap1 1
  
  foreach iT [lrange $id_Hole 0 end-[expr {1+($IFLUTE<1)}]] {
    if {[lindex $D0P $ifor]>0} {
      if {$beforelastholelower>[expr {$hP+$hhzoom}]} {
      # The hole before the previous one is separatated from the previous hole
	set gap1 1
      } else {
      # Overlap of the two previous holes
	set gap1 0
      }
      # Center altitude of the hole
      if {[llength $L]<$ifor} {
      #
      } else {
      set hP [expr {2*$hzoom+[::tcl::mathop::+ {*}[lrange $L [expr {$ifor+1}] $ltrouf]]*$dzoom}]
      }
      lappend hPs $hP
      # Hole represented radius idea : kind of arctan((diameter-median)/pseudovariance)
      # very high diameter values are represented quite the same big size, 
      # very low diameter values are represented quite the same low size, 
      # other diameter values are represented with sizes varying between those extrema sizes
      set hhzoom [expr {$hzoom*3/4+$hzoom*atan(([lindex $D0P $ifor]-$tmpmedian)/$pseudovar)/(4*1.6)}]
      lappend hhzooms $hhzoom
      incr xcent $altern
      set xcentcur $xcent
      set altern [expr {-$altern}]
      if {$gap1>0} {
        if {$lastholelower>[expr {$hP+$hhzoom}]} {
	  set xcentcur $xcent0
        }
        set gap1 0
      }
      if {$ifor2>0} {
        lappend xcents $xcentcur
      }
      set beforelastholelower $lastholelower
      set lastholelower [expr {$hP-$hhzoom}]
      incr ifor2
    }
    incr ifor
  }      
  incr xcent $altern
  set xcentcur $xcent      
  if {$beforelastholelower>[expr {$hP+$hhzoom}]} {
    # The hole before the previous one is separatated from the previous hole
    set xcentcur $xcent0
  }
  lappend xcents $xcentcur
   
  variable ifor 0
  set ifor2 0    
    
  set iicol 0
  foreach iT [lrange $id_Hole 0 end-[expr {1+($IFLUTE<1)}]] {
      if {[lindex $D0P $ifor]>0} {    
        set hhzoom [lindex $hhzooms $ifor2]
        set tmpP [lindex $hPs $ifor2]
        set xcent [lindex $xcents $ifor2]
        incr ifor2
        lappend ldtrou [::exprall "{$xcent-$hhzoom} {$tmpP-$hhzoom} {$xcent+$hhzoom} {$tmpP+$hhzoom}"]
        lappend ldiT $iT
    }
    incr ifor
  }
  
  set idframefinger [list ]
  # Actions to do when -Entering, -Clicking, -Leaving a doigte
  set pendingact  [list "#" "#" "#"]
  set idprec [tk::button .visu_edit_fingering.right.existprev -text "<"] 
  .visu_edit_fingering.right.existprev configure  -command "edit_fingering_namespace::select_vis_fingering \[incr difirstvis -1\] \$dnbvis"
  grid $idprec -column $iicol -row 0 -sticky ws
  variable tmpidf
  
  variable ifingerp1
  set ifingerp1 0
  for {set ifinger 0} {$ifinger<$NTESSC} {incr ifinger} {
    set iirow -1
    incr iicol
    incr ifingerp1
    
    global cnote$ifinger
    global cdegre$ifinger
    global cjust$ifinger
    
    lappend idframefinger [tk::frame .visu_edit_fingering.right.framefinger$ifinger]
    set tmpidf [lindex $idframefinger end] 
    grid $tmpidf -column $iicol -row 0
    
    set cnote$ifinger  [regsub -all {'} [lindex $noms_notes $ifinger] {}]
    set cdegre$ifinger [lindex [lindex $degres_tessiture_notes $ifinger] 2]
    set cjust$ifinger  [lindex [lindex $degres_tessiture_notes $ifinger] 0]
    
    set icmd "set lifor \[lsearch \$idframefinger $tmpidf\]"
    
    set icmd2 "$icmd
    if {\[string equal \[lindex \$noms_notes \$lifor\] '$\cnote$ifinger'\]} {} else {
      lset noms_notes \$lifor '$\cnote$ifinger'
      geofingeringchanged;
    }"
    grid [tk::entry .visu_edit_fingering.right.framefinger$ifinger.getNote -textvariable cnote$ifinger -width 5 -validate focusout -validatecommand "$icmd2;return 1"] -column $iicol -row [incr iirow] -sticky n
    bind .visu_edit_fingering.right.framefinger$ifinger.getNote <Return> "$icmd2"
    
    set icmd2 "$icmd
    if {\[string equal \[lindex \[lindex \$degres_tessiture_notes \$lifor\] 2\] $\cdegre$ifinger\]} {} else {
      lset degres_tessiture_notes \$lifor \[lreplace \[lindex \"\$degres_tessiture_notes\" \$lifor\] 2 2 $\cdegre$ifinger\];
      ::edit_fingering_namespace::updateNTESSG;
      geofingeringchanged;
    }"
    grid [tk::entry .visu_edit_fingering.right.framefinger$ifinger.getDegre -text cdegre$ifinger -width 5 -justify center -validate focusout -validatecommand "$icmd2;return 1"] -column $iicol -row [incr iirow] -sticky n
    bind .visu_edit_fingering.right.framefinger$ifinger.getDegre <Return> "$icmd2"
    
    set icmd2 "$icmd
    if {\[string equal \[lindex \[lindex \$degres_tessiture_notes \$lifor\] 0\] $\cjust$ifinger\]} {} else {
      lset degres_tessiture_notes \$lifor \[lreplace \[lindex \"\$degres_tessiture_notes\" \$lifor\] 0 0 $\cjust$ifinger\];
      geofingeringchanged;
    }"
    grid [tk::entry .visu_edit_fingering.right.framefinger$ifinger.getJust -text cjust$ifinger -width 5 -justify right -validate focusout -validatecommand "$icmd2;return 1"] -column $iicol -row [incr iirow] -sticky n
    bind .visu_edit_fingering.right.framefinger$ifinger.getJust <Return> "$icmd2"
    
    grid [tk::canvas .visu_edit_fingering.right.framefinger$ifinger.fingers -width 50 -height $fingering_size] -column $iicol -row [incr iirow] -sticky n
    grid [tk::label .visu_edit_fingering.right.framefinger$ifinger.rank -text $ifingerp1 -width 3] -column $iicol -row [incr iirow] -sticky s
    
    set ifor 0
    foreach ifor2 {{<Enter>} {<1>} {<Leave>}} {
      foreach ifor3 {fingers rank} {
        bind .visu_edit_fingering.right.framefinger$ifinger.$ifor3 $ifor2 "edit_fingering_namespace::actfinger \[lindex \$pendingact $ifor\]  \[lsearch \$idframefinger $tmpidf\] $ifinger"
      }
    incr ifor
    }
    
    foreach ifor {0 1 2 3} {
      grid rowconfigure .visu_edit_fingering.right.framefinger$ifinger $ifor -weight 0
    }
    
    foreach ifor {5 45} {
      .visu_edit_fingering.right.framefinger$ifinger.fingers create line $ifor 0 $ifor $fingering_size -tags "L$ifinger"
    }

    set ifor 0
  
  # Draw holes for current doigt
    foreach iT $ldiT {
        .visu_edit_fingering.right.framefinger$ifinger.fingers create oval {*}[lindex $ldtrou $ifor] -tags H$iT -fill black -activeoutline $activecolor -activedash 6  -activewidth 5
        .visu_edit_fingering.right.framefinger$ifinger.fingers  bind H$iT <1> "
	set iifinger \[lsearch \$idframefinger $tmpidf\]
	puts \"Trou id : $iT / ifinger : $ifinger / iifinger : \$iifinger\"
        if {\[lsearch -exact -integer \[lindex \$refdoigte_notes \$iifinger\] $iT\]<0} {
        puts \[lindex \$refdoigte_notes \$iifinger\]
        lset  refdoigte_notes \$iifinger \"\[lindex \$refdoigte_notes \$iifinger\] $iT\"
        .visu_edit_fingering.right.framefinger$ifinger.fingers itemconfigure H$iT -fill \"lightgrey\"
	puts \[lindex \$refdoigte_notes \$iifinger\]
	} else {
	puts \[lindex \$refdoigte_notes \$iifinger\]
	lset  refdoigte_notes \$iifinger \"\[lsearch -all -inline -not -exact -integer \[lindex \$refdoigte_notes \$iifinger\] $iT\]\"
        puts \[lindex \$refdoigte_notes \$iifinger\]
        .visu_edit_fingering.right.framefinger$ifinger.fingers itemconfigure H$iT -fill \"black\"
        }
	geofingeringchanged
        "
	.visu_edit_fingering.right.framefinger$ifinger.fingers  bind H$iT <Enter> "puts $iT
	.maincanvas itemconfigure HO$iT -outline \$activecolor -width 5 -dash 8
	handcursor .visu_edit_fingering.right.framefinger$ifinger.fingers"
	.visu_edit_fingering.right.framefinger$ifinger.fingers  bind H$iT <Leave> "retrace
	defaultcursor .visu_edit_fingering.right.framefinger$ifinger.fingers"
    incr ifor
    }
    foreach iT [lindex $refdoigte_notes $ifinger] {
    .visu_edit_fingering.right.framefinger$ifinger.fingers itemconfigure H$iT -fill "lightgrey"
    }
  }
  set idsuiv [tk::button .visu_edit_fingering.right.existnext -text ">" -command "edit_fingering_namespace::select_vis_fingering \[incr difirstvis\] \$dnbvis"]
  grid $idsuiv -column [incr iicol] -row 0 -sticky ws
  
  set difirstvis 0
  #grid remove .visu_edit_fingering.right.existprev
  .visu_edit_fingering.right.existprev configure -state disable

  set dnbvis $ifingerp1
  variable nbmaxscreen [expr {([winfo screenwidth .]-140)/55+1}]
  if {$nbmaxscreen<$dnbvis} {
    set dnbvis $nbmaxscreen
  } else {
    #grid remove $idsuiv
    $idsuiv configure -state disable
  }
  select_vis_fingering $difirstvis $dnbvis
  grid remove .visu_edit_fingering.tmpright

  wm geometry .visu_edit_fingering [regsub {^[^x]*x[0-9]*([^0-9])} $wgeo_efing {\1}]

  # Call macro customizable proc, default = dummy proc
  end_fingering_proc
}


proc updateNTESSG {} {
  # Look for the highest Degree
  global NTESSC
  global NTESSG
  global degres_tessiture_notes
  variable ifor
  variable tmpNTESSG
  set tmpNTESSG 0
  for {set ifor 0} {$ifor<$NTESSC} {incr ifor} {
    set degtessnot [lindex [lindex $degres_tessiture_notes $ifor] 2]
    if {$degtessnot>$tmpNTESSG} {set tmpNTESSG $degtessnot}
  }
  set NTESSG $tmpNTESSG
}

proc ifvselect_vis_fingering {lifirstvis} {
  global difirstvis
  global dnbvis
  set difirstvis $lifirstvis
  select_vis_fingering $difirstvis $dnbvis
}

proc select_vis_fingering {ifirstvis nbvis} {
  global idframefinger
  global idprec
  global idsuiv
  variable ifor
  variable len
  global difirstvis
  set len [llength $idframefinger]
  if {$ifirstvis>=$len} {
    set ifirstvis [expr {$len-1}]
  }
  if {$ifirstvis<0} {set ifirstvis 0}
  if {[expr {$ifirstvis+$nbvis}]>$len} {
    set nbvis [expr {$len-$ifirstvis}]
  }
  for {set ifor 0} {$ifor<$ifirstvis} {incr ifor} {
    grid remove [lindex $idframefinger $ifor]
  }
  for {set ifor $ifirstvis} {$ifor<[expr {$nbvis+$ifirstvis}]} {incr ifor} {
    grid [lindex $idframefinger $ifor]
  }
  #if {$ifor<$len} {grid $idsuiv} else {grid remove $idsuiv}
  if {$ifor<$len} {$idsuiv configure -state active} else {$idsuiv configure -state disable}
  for {set ifor [expr {$nbvis+$ifirstvis}]} {$ifor<$len} {incr ifor} {
    grid remove [lindex $idframefinger $ifor]
  }
  #if {$ifirstvis>0} {grid $idprec} else {grid remove $idprec}
  if {$ifirstvis>0} {$idprec configure -state active} else {$idprec configure -state disable}
  set difirstvis $ifirstvis
}

proc actfinger {cmdD ifinger indgui} {
  if {[string equal "$cmdD"  "#"]<1} {$cmdD $ifinger $indgui}
}

proc enter_suppr {ifinger indgui} {
  global old_edit_finger_status
  global edit_finger_status
  .visu_edit_fingering configure -cursor X_cursor
  set old_edit_finger_status $edit_finger_status
  set edit_finger_status "Supprimer Rang [expr {$ifinger+1}]"
  .visu_edit_fingering.right.framefinger$indgui.fingers itemconfigure "L$indgui" -width 3 -fill red
}

proc leave_suppr {ifinger indgui} {
  global old_edit_finger_status
  global edit_finger_status
  .visu_edit_fingering configure -cursor {}
  set edit_finger_status $old_edit_finger_status
  .visu_edit_fingering.right.framefinger$indgui.fingers itemconfigure "L$indgui" -width 1 -fill black
}

proc suppr_fingering {ifinger indgui} {
  .visu_edit_fingering configure -cursor {}
  foreach ilist {NTESSC 
    noms_notes degres_tessiture_notes refdoigte_notes 
    idframefinger 	pendingact 
    edit_finger_status 	difirstvis dnbvis} {
    global $ilist
  }
  if {$NTESSC>1} {
  foreach ifor2 {noms_notes degres_tessiture_notes refdoigte_notes} {
    lset $ifor2 [lreplace [lappend $ifor2] $ifinger $ifinger]
  }
  incr NTESSC -1
  geofingeringchanged
  variable toffset
  #set toffset [lindex [lindex $degres_tessiture_notes 0] 2]
  #incr toffset -1
  #variable degtessnot
  set toffset 0
  # Renumerote degre et tessiture
  # Suppose Rang croissant en lecture de fichier
  for {set ifor 0} {$ifor<$NTESSC} {incr ifor} {
    set degtessnot [lindex $degres_tessiture_notes $ifor]
    set degtessnot [list [lindex $degtessnot 0] [expr {1+$ifor}] [expr {[lindex $degtessnot 2]-$toffset}] ]
    set degres_tessiture_notes [lreplace $degres_tessiture_notes $ifor $ifor $degtessnot]
  }
  updateNTESSG
  
  puts "$ifinger ifinger"
  
  destroy [lindex $idframefinger $ifinger]
  variable iicol
  set iicol [expr {$ifinger+1}]
  for {set ifor $iicol} {$ifor<=$NTESSC} {incr ifor} {
    [lindex $idframefinger $ifor].rank configure -text $ifor
    grid remove [lindex $idframefinger $ifor] 
    grid [lindex $idframefinger $ifor] -column $iicol -row 0
    incr iicol
  }
  set idframefinger [lreplace $idframefinger $ifinger $ifinger]
  if {[winfo exists .visu_accuracy]} {
    # Let geometry be free
    wm geometry .visu_accuracy ""
  } 
  }  
  set pendingact  [list "#" "#" "#"]
  set edit_finger_status ""
  select_vis_fingering $difirstvis $dnbvis
  focus .visu_edit_fingering.commands.supprfinger
}

proc enter_add {ifinger indgui} {
  global old_edit_finger_status
  global edit_finger_status
  .visu_edit_fingering configure -cursor hand2
  set old_edit_finger_status $edit_finger_status
  set edit_finger_status "Dupliquer Rang [expr {$ifinger+1}]"
  .visu_edit_fingering.right.framefinger$indgui.fingers itemconfigure "L$indgui" -width 3 -fill blue
}

proc leave_add {ifinger indgui} {
  global old_edit_finger_status
  global edit_finger_status
  .visu_edit_fingering configure -cursor {}
  set edit_finger_status $old_edit_finger_status
  .visu_edit_fingering.right.framefinger$indgui.fingers itemconfigure "L$indgui" -width 1 -fill black
}

proc add_fingering {ifinger indgui} {
  .visu_edit_fingering configure -cursor {}
  foreach ilist {NTESSC
  noms_notes degres_tessiture_notes refdoigte_notes
  idframefinger 	pendingact 
  edit_finger_status} {
    global $ilist
  }
  variable degtessnot

  .visu_edit_fingering.right.framefinger$indgui.fingers itemconfigure "L$indgui" -width 1 -fill black
  incr NTESSC
  #global idsuiv
  #grid remove $idsuiv
  #grid $idsuiv -column [expr $NTESSC+1] -row 0 -sticky ws
  for {set ifor 0} {$ifor<[expr {$NTESSC-1}]} {incr ifor} {
  #  grid remove [lindex $idframefinger $ifor] 
  destroy [lindex $idframefinger $ifor] 
  #  grid [lindex $idframefinger $ifor] -column [expr $ifor+1] -row 0
  }
  set degtessnot [lindex $degres_tessiture_notes $ifinger]
  lset degtessnot 1 123
  #$ifinger
  set degres_tessiture_notes [linsert $degres_tessiture_notes $ifinger $degtessnot]
  set degtessnot [lindex $refdoigte_notes $ifinger]
  set refdoigte_notes [linsert $refdoigte_notes $ifinger $degtessnot]
  set degtessnot [lindex $noms_notes $ifinger]
  set noms_notes [linsert $noms_notes $ifinger $degtessnot]
  for {set ifor $ifinger} {$ifor<$NTESSC} {incr ifor} {
    set degtessnot [lindex $degres_tessiture_notes $ifor]
    lset degtessnot 1 [expr {1+$ifor}]
    set degres_tessiture_notes [lreplace $degres_tessiture_notes $ifor $ifor $degtessnot]
  }
  if {[winfo exists .visu_accuracy]} {
     # Let geometry be free
     wm geometry .visu_accuracy ""
  } 
  updateNTESSG
  geofingeringchanged
  set pendingact  [list "#" "#" "#"]
  set edit_finger_status ""
  global wgeo_efing
  set wgeo_efing [wm geometry .visu_edit_fingering]
  set .visu_edit_fingering ""
  #edit_fingering_namespace::edit_fingering -1
  edit_fingering_namespace::edit_fingering 0
  focus .visu_edit_fingering.commands.addfinger
}

proc enter_calc {ifinger indgui} {
  global old_edit_finger_status
  global edit_finger_status
  .visu_edit_fingering configure -cursor hand2
  set old_edit_finger_status $edit_finger_status
  set edit_finger_status "Calculer Rang [expr {$ifinger+1}]"
  .visu_edit_fingering.right.framefinger$indgui.fingers itemconfigure "L$indgui" -width 3 -fill darkgreen
}

proc leave_calc {ifinger indgui} {
  global old_edit_finger_status
  global edit_finger_status
  .visu_edit_fingering configure -cursor {}
  set edit_finger_status $old_edit_finger_status
  .visu_edit_fingering.right.framefinger$indgui.fingers itemconfigure "L$indgui" -width 1 -fill black
}

proc calc_fingering {ifinger indgui} {
  global pendingact
  global edit_finger_status
  leave_calc $ifinger $indgui
  set pendingact  [list "#" "#" "#"]
  set edit_finger_status ""
  global lastuserin
  set lastuserin [expr {1+$ifinger}]
  ::calculate 1 $lastuserin
  focus .visu_edit_fingering.commands.calcfinger
}


}

# Exporter la perce en mm au format DXF
# Les deux points extrmes sont complts par un retour sur l'axe de rvolution :
# La rvolution complte de la polyline dxf autour de l'axe engendre ainsi une forme ferme
# Export axial canal geometry in mm to a DXF file
# On-revolution axis point are added to Top and bottom points :
# thus a complete revolution of the DXF polyline generates a closed shape
proc exportDXF {dxf_filename} {
  foreach ilist {curname 	L D0 DL 	IFLUTE 	LP D0P DLP} {
    global $ilist
  }
  
  if {[string length $dxf_filename]<1} {
    set dxf_filename [tk_getSaveFile -filetypes {{{.DXF file} {.dxf}}} -defaultextension .dxf -initialfile [regsub  -all {\.[dD][aA][tT]} "$curname" {.dxf}] ]
  }
  puts $dxf_filename
  if {[string length $dxf_filename]>0} {
  variable fichierDXF [open $dxf_filename w ]
  variable iligne
  variable itronc
  foreach iligne {0 SECTION 2 ENTITIES 0 LWPOLYLINE 8 Tuttperce 90} {
  puts $fichierDXF $iligne
  }
  variable listXY {{0 0}}
  variable oldX 0
  variable newX 0
  variable oldY 0
  # Export radii instead of diameters : factor 0.5
  for {set ifor 0} {$ifor<[expr {[llength $L]-1}]} {incr ifor} {
    set newY [format %G  [expr {0.5*1000.0*[lindex $DL $ifor]}]]
    if {[expr {abs($newY-$oldY)>0}]} {lappend listXY "$oldX $newY"}
    set oldX [format %G  [expr {1000.0*[::tcl::mathop::+ {*}[lrange $L 0 [expr {$ifor}] ]]}]]
    set oldY [format %G  [expr {0.5*1000.0*[lindex $D0 $ifor]}]]
    lappend listXY "$oldX $oldY"
  }
  # If IFLUTE<1, get the dimensions of the last conical frustum from the hole
  if {$IFLUTE<1} {
    incr ifor -1
    set newY [format %G  [expr {0.5*1000.0*[lindex $DLP $ifor]}]]
    if {[expr {abs($newY-$oldY)>0}]} {lappend listXY "$oldX $newY"}
    lset oldX [format %G  [expr {1000.0*([lindex $LP $ifor]+[::tcl::mathop::+ {*}[lrange $L 0 [expr {$ifor}] ]])}]]
    set oldY [format %G  [expr {0.5*1000.0*[lindex $D0P $ifor]}]]
    lappend listXY "$oldX $oldY"
  } else {
    set newY [format %G  [expr {0.5*1000.0*[lindex $DL $ifor]}]]
    if {[expr {abs($newY-$oldY)>0}]} {lappend listXY "$oldX $newY"}
    set oldX [format %G  [expr {1000.0*[::tcl::mathop::+ {*}[lrange $L 0 [expr {$ifor}] ]]}]]
    set oldY [format %G  [expr {0.5*1000.0*[lindex $D0 $ifor]}]]
    lappend listXY "$oldX $oldY"
  }
  lappend listXY "$oldX 0"
  puts $fichierDXF [llength $listXY]
  foreach itronc $listXY {
    foreach iligne "10 [lindex $itronc 0] 20 [lindex $itronc 1]" {
      puts $fichierDXF $iligne
    }
  }
  foreach iligne {0 ENDSEC 0 EOF} {
  puts $fichierDXF $iligne
  }
  close $fichierDXF
  }
}

proc prevent_action_if_unsaved {} {
  global file_unsaved
  global curname
  global at_least_one_opened
  if {$file_unsaved>0} {
    set savechoice [tk_messageBox -icon warning -title "Modifications non sauvegardes" -message "Des modifications ont t apportes au fichier $curname.
    \n\nSauver les modifications apportes  $curname ?" -type yesnocancel -default cancel]
    switch -- $savechoice {
      yes {set curnamenew [tk_getSaveFile -filetypes {{{.DAT file} {.DAT .dat}}} -initialfile $curname]
        if {[string length $curnamenew]>0} {
        set curname $curnamenew
        write_datfile_namespace::save_to_filename $curname
        set curname [file tail $curname]
	geofingeringsaved}
        set file_unsaved 0
	}
      no {set file_unsaved 0}
      cancel {return}
    }
  }
}

proc exit_all_program {} {
  global file_unsaved
  prevent_action_if_unsaved
  if {$file_unsaved<1} {
    exit
  }
 }
 
set firsthelplaunch 1
 
proc open_help_window {which_window} {
  global help_text
  global wgeo_help
  global firsthelplaunch
  if {[winfo exists .help_window]} {
    set wgeo_help "[wm geometry .help_window]"
    variable w
    foreach w [winfo children .help_window] {
      destroy $w
    }
  } else {
    toplevel .help_window
    wm protocol .help_window WM_DELETE_WINDOW {
      set wgeo_help "[wm geometry .help_window]"
      wm withdraw .help_window
      set firsthelplaunch 1
    }
  }
  wm deiconify .help_window
  wm geometry .help_window [regsub {^[^x]*x[0-9]*([^0-9])} $wgeo_help {\1}]
  wm geometry .help_window ""
  wm title .help_window {Fentre d'aide contextuelle TUTT}
  grid [tk::frame .help_window.buttons] -column 0 -row 0 -sticky nwe
  set icol 0
  grid [tk::button .help_window.buttons.main -text "Fentre principale" -command "open_help_window {main}"] -column [incr icol] -row 0 -sticky nwes
  grid [tk::button .help_window.buttons.geom -text "Gomtrie" -command "open_help_window {geometry}"] -column [incr icol] -row 0 -sticky nwes
  grid [tk::button .help_window.buttons.holes -text "Trous" -command "open_help_window {holes}"] -column [incr icol] -row 0 -sticky nwes
  grid [tk::button .help_window.buttons.finger -text "Doigts" -command "open_help_window {finger}"] -column [incr icol] -row 0 -sticky nwes
  grid [tk::button .help_window.buttons.accuracy -text "Justesse" -command "open_help_window {accuracy}"] -column [incr icol] -row 0 -sticky nwes
  grid [tk::button .help_window.buttons.impedance -text "Impdance/Admittance" -command "open_help_window {impedance}"] -column [incr icol] -row 0 -sticky nwes
  
  grid [tk::scrollbar .help_window.sztxtbar -orient vertical -command {.help_window.lu yview} ] -column 2 -row 1 -sticky ns
  grid [tk::text .help_window.lu -width 80 -height 20 -yscrollcommand {.help_window.sztxtbar set}] -column 0 -row 1 -sticky ns -columnspan 2
  grid rowconfigure .help_window 1 -weight 1
  #grid [tk::text .lu] -column 0 -row 0 -columnspan 2
  .help_window.lu tag configure BLUFG -foreground blue
  #grid [tk::frame .help_window.sendbar] -column 0 -row 1 -columnspan 3 -sticky we

  .help_window.lu insert 0.0 "Cette fentre s'ouvre aprs un calcul portant sur une note spcifique.
Cette courbe reprsente l'impdance  l'embouchure de l'instrument, 
en fonction de la pulsation 
(ou, plus exactement, la partie imaginaire de cette impdance). 

On peut aussi choisir de reprsenter la fonction admittance 
au lieu de la fonction impdance. 
Les deux choix donnent le mme rsultat, mais 
la reprsentation en impdance est mieux adapte au cas de fltes, 
alors que la reprsentation en admittance est plus pertinente pour 
le cas des instruments  anche solide.  

Les frquences en jeu correspondent 
aux zros de cette fonction admittance ou impdance. 

Avec un oeil exerc, cette courbe dit beaucoup de choses: 
des zros rgulirement espacs avec des arches coupant franchement l'axe 
signalent un instrument avec une bonne harmonicit, 
un timbre riche et une bonne facilit d'mission.\n\n"
  .help_window.lu insert 0.0 "Fentre d'impdance/admittance :\n" "helptitle impedance"

  .help_window.lu insert 0.0 "La fentre de justesse s'ouvre aprs un calcul portant sur toutes les notes.
Ces histogrammes rsument sur chaque note de l'instrument
 - la justesse                      (barres rouges), 
 - l'harmonicit                    (barres blanches) 
 - le champ de libert en frquence (triangles jaunes). 
Ces deux derniers champs peuvent tre affichs ou masqus 
en cliquant sur leur icne situe dans la lgende en haut.

Cliquer sur la barre correspondant  une note 
permet de lancer directement le calcul dtaill de la note correspondante.\n\n"
  .help_window.lu insert 0.0 "Fentre de Justesse : \n" "helptitle accuracy"

  .help_window.lu insert 0.0 "Ce schma est la table des doigts acoustique de l'instrument, 
indpendamment de tout cltage. (noir= trou bouch; blanc = trou ouvert). 

Une note d'un mme degr peut avoir plusieurs doigts. 

Le bouton diapason permet de choisir la frquence du  La  de rfrence. 

Le paramtre NTESSB indique la position de la note la plus grave de la table
(de degr 1), situe  NTESSB demi-tons au-dessous du  La  de rfrence.\n\n"
.help_window.lu insert 0.0 "Fentre d'dition des doigts : \n" "helptitle finger"

  .help_window.lu insert 0.0 "Chaque trou latral du plan de perce est reprsent par 
une chemine en forme de tronc de cne, 
l'vasement du tronc de cne permettant de reprsenter 
le sous-coupage ventuel du trou.

Cette fentre rsume la gomtrie du trou surlign 
(diamtres aux deux bouts, hauteur). 

On peut choisir de couvrir un trou par une cl, 
auquel cas il faudra spcifier le style et la leve de ladite cl. \n\n"
  .help_window.lu insert 0.0 "Fentre d'dition de trou :\n" "helptitle holes"

  .help_window.lu insert 0.0 "Chaque tronon du plan de perce est reprsent par un tronc de cne. 
Cette fentre rsume la gomtrie du tronon surlign (diamtres aux deux bouts, longueur). 

La rugosit de la perce a une grande influence sur les rsultats. 
L'utilisateur peut la choisir dans la fentre ofilib. 
Choisir le paramtre  ofilib = 1 pour une perce parfaitement lisse, 
et                    ofilib = 2 pour un tube un peu rugueux (bois). \n\n"
  .help_window.lu insert 0.0 "\Fentre d'dition de la gomtrie :\n" "helptitle geometry"

  .help_window.lu insert 0.0 "Ce schma rsume le plan de perce de l'instrument. 
Les paramtres du tronon ou trou courant situ sous la souris 
s'affichent dans la barre d'tat tout en bas de la fentre.

Cliquer sur un tronon de la perce (zones situes en partie haute du schma) 
ou sur un trou latral (lignes verticales en partie basse du schma)
permet de modifier sa gomtrie. 
Pour les trous, un clic entre 2 lignes verticales 
ouvrira le trou le plus proche du curseur.

Cliquer sur le bouton Calcul (en haut  gauche)
permet de lancer le calcul d'une note de l'instrument, 
sur un doigt spcifi par l'utilisateur.

La courbe rouge qui s'affiche alors en surimpression sur le plan de perce 
reprsente le champ de pression acoustique dans l'instrument pour cette note.
Si la souris passe sur la courbe rouge, la courbe passe en surbrillance, et
des informations associes s'affichent dans la barre d'tat 
tout en bas de la fentre.\n\n"
  .help_window.lu insert 0.0 "Fentre principale : \n" "helptitle main"

  .help_window.lu tag configure helptitle -foreground blue -font "helvetica 14"

  # Look for corresponding window :
    puts $which_window
    set where_togo [.help_window.lu tag ranges "$which_window"]
    puts $where_togo
    .help_window.lu see [lindex $where_togo 0]
    raise .help_window
    focus .help_window
}

proc ask_new_file_and_open {} {
  global file_unsaved
  global curname
  global at_least_one_opened
  global accuracy_change
  global pressure_change
  global impedance_change
  global status_bar
  global launched
  prevent_action_if_unsaved
  if {$file_unsaved<1} {
    global autoopen
    if {$autoopen<1} {
      #Demande du nom de fichier par interface graphique
      set dat_input_file_name [tk_getOpenFile -filetypes {{{.DAT file} {.DAT .dat}}}]
    } else {
      set dat_input_file_name $curname
    }
    set autoopen 0
    if {[string length $dat_input_file_name]>0} {
    set file_unsaved 0
    set accuracy_change "*"
    set pressure_change "*"
    set impedance_change "*"
    puts $dat_input_file_name
    if {[winfo exists .visu_accuracy]} {
       # Let geometry be free
       wm geometry .visu_accuracy ""
    } 
    read_datfile_namespace::open_datfile $dat_input_file_name
    # Adapt the accuracy window size to the new file
    
    draw_main_view
    set at_least_one_opened 1
    .entete.calculate configure -state normal
    .entete.edit_fingering configure -state normal
    .entete.savefile configure -state normal
    .entete.exporttoDXF configure -state normal
    .status_bar configure -text "Cliquer sur les coupes des tronons (en haut) ou sur les trous ou interfaces entre tronons (en bas) pour les diter."
    set launched 0
    }
    wm deiconify .
    global lastuserin
    set lastuserin {}
  }
}

ask_new_file_and_open

# Run macro if asked
if {$macrotorun>0} {
  puts "Lancement du code macro contenu dans $macrofiletorun"
  source $macrofiletorun
  incr macrotorun -1
}